/*
 * #%L
 * jTimer
 * 
 * $Id: SystemInfoFactory.java 2793 2012-02-09 15:28:43Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2011 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.jtimer.ui.system;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.ui.system.macos.MacOSSystemInfo;
import org.chorem.jtimer.ui.system.unix.UnixSystemInfo;
import org.chorem.jtimer.ui.system.win32.Win32SystemInfo;

import com.sun.jna.Platform;

/**
 * Build system info determined from system.
 * 
 * @author chatellier
 * @version $Revision: 2793 $
 * 
 * Last update : $Date: 2012-02-09 16:28:43 +0100 (Thu, 09 Feb 2012) $
 * By : $Author: echatellier $
 */
public class SystemInfoFactory {

    /** log */
    private static Log log = LogFactory.getLog(SystemInfoFactory.class);

    /** Single instance */
    protected static SystemInfo instance;

    /**
     * SystemInfoFactory Constructor.
     */
    protected SystemInfoFactory() {

    }

    /**
     * Return system info depending on system.
     * 
     * @return SystemInfo instance
     * @see SystemInfo
     * @throws UnsupportedSystemInfoException if system info is not supported
     *             for system
     */
    public static SystemInfo getSystemInfo()
            throws UnsupportedSystemInfoException {

        if (instance == null) {
            String os = System.getProperty("os.name");

            // log it
            if (log.isInfoEnabled()) {
                log.info("Try do build system info for system : " + os);
            }

            // try windows
            if (Platform.isWindows()) {
                instance = new Win32SystemInfo();
            } else if (Platform.isLinux()) {
                instance = new UnixSystemInfo();
            } else if (Platform.isMac()) {
                instance = new MacOSSystemInfo();
            } else {
                // system unknown
                throw new UnsupportedSystemInfoException(
                        "Can't get system info for " + os);
            }
        }

        return instance;
    }
}
