/*
 * #%L
 * jTimer
 * 
 * $Id: JTimerFactory.java 2806 2012-03-07 16:38:55Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.jtimer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.io.Saver;
import org.chorem.jtimer.ws.ProjectManagement;

/**
 * JTimer config class.
 * 
 * @author chatellier
 * @version $Revision: 2806 $
 * 
 * Last update : $Date: 2012-03-07 17:38:55 +0100 (Wed, 07 Mar 2012) $
 * By : $Author: echatellier $
 */
public class JTimerFactory {

    /** Logger */
    private static Log log = LogFactory.getLog(JTimerFactory.class);

    /** ProjectManagement */
    protected static ProjectManagement projectManagement;

    /** Saver */
    protected static Saver saver;

    /**
     * Constructeur.
     */
    protected JTimerFactory() {
        // disable instanciation
    }

    /**
     * Return an implementation on a distant web service.
     * 
     * Use jtimer.service.class property to found class and
     * jtimer.service.endpoint and jtimer.service.resource to init it.
     * 
     * @return implementation on a distant web service.
     */
    public static ProjectManagement getProjectManagementService() {

        if (projectManagement == null) {

            Class implementationClass = JTimer.config.getServiceClass();

            // log
            if (log.isInfoEnabled()) {
                log.info("Using service class : " + implementationClass);
                log.info(" with service endpoint : " + JTimer.config.getServiceEndpoint());
                log.info(" with service resource : " + JTimer.config.getServiceResource());
            }

            // By default jTimer won't synchronize
            // so implementationClass can be null
            if (implementationClass != null) {

                try {
                    // get instance
                    projectManagement = (ProjectManagement)implementationClass.newInstance();

                    // init instance
                    projectManagement.setEndpoint(JTimer.config.getServiceEndpoint());
                    projectManagement.setResourceName(JTimer.config.getServiceResource());
                } catch (InstantiationException e) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't instanciate class : "
                                + implementationClass, e);
                    }
                } catch (IllegalAccessException e) {
                    if (log.isErrorEnabled()) {
                        log.error(
                                "Can't access class : " + implementationClass,
                                e);
                    }
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info("No sync information given, won't synchronize");
                }
            }
        }

        return projectManagement;
    }

    /**
     * Get saver manager.
     * 
     * @return saver manager
     */
    public static Saver getFileSaver() {

        if (saver == null) {

            Class saverClass = JTimer.config.getIOSaverClass();

            // log
            if (log.isInfoEnabled()) {
                log.info("Using saver class : " + saverClass);
                log.info(" with saver home directory : " + JTimer.config.getIOSaverDirectory());
                log.info(" with auto save delay : " + JTimer.config.getIOSaverAutoSaveDelay());
            }

            try {
                // get instance
                saver = (Saver) saverClass.newInstance();

                // init instance
                saver.setSaveDirectory(JTimer.config.getIOSaverDirectory());

                // set delay to saver
                saver.setAutoSaveDelay(JTimer.config.getIOSaverAutoSaveDelay() * 1000);

            } catch (InstantiationException e) {
                if (log.isErrorEnabled()) {
                    log.error("Can't instanciate class : " + saverClass, e);
                }
            } catch (IllegalAccessException e) {
                if (log.isErrorEnabled()) {
                    log.error("Can't access class : " + saverClass, e);
                }
            }
        }

        return saver;
    }
}
