/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.treetable;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;
import org.chorem.jtimer.data.TimerCore;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.ui.treetable.ProjectsAndTasksCellRenderer;
import org.chorem.jtimer.ui.treetable.ProjectsAndTasksModel;
import org.chorem.jtimer.ui.treetable.dnd.TimerTaskTransferHandler;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class ProjectsAndTasksTable
extends JXTreeTable {
    private static final long serialVersionUID = -6909972377431117193L;
    protected ProjectsAndTasksModel treeTableModel;
    protected ProjectsAndTasksCellRenderer treeCellRenderer;

    public ProjectsAndTasksTable(Application application, TimerCore core) {
        ApplicationContext ctxt = application.getContext();
        ResourceManager mgr = ctxt.getResourceManager();
        ResourceMap resourceMap = mgr.getResourceMap(ProjectsAndTasksTable.class);
        ArrayList<String> columnIdentifiers = new ArrayList<String>();
        columnIdentifiers.add(resourceMap.getString("projectsAndTaskColumnName", new Object[0]));
        columnIdentifiers.add(resourceMap.getString("todayTimeColumnName", new Object[0]));
        columnIdentifiers.add(resourceMap.getString("totalTimeColumnName", new Object[0]));
        this.treeTableModel = new ProjectsAndTasksModel(this, core, columnIdentifiers);
        this.treeCellRenderer = new ProjectsAndTasksCellRenderer(this, core);
        this.setTreeCellRenderer(this.treeCellRenderer);
        this.setTreeTableModel((TreeTableModel)this.treeTableModel);
        this.setBackground(Color.WHITE);
        core.getData().addDataEventListener(this.treeTableModel);
        this.setDragEnabled(true);
        this.setTransferHandler(new TimerTaskTransferHandler(application, core.getData()));
    }

    public void setShowClosed(boolean closed) {
        this.treeTableModel.setShowClosed(closed);
    }

    public List<TimerTask> getSelectedTasks() {
        ArrayList<TimerTask> results = new ArrayList<TimerTask>();
        TreePath[] paths = this.getTreeSelectionModel().getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                Object[] pathWay;
                if (path == null || (pathWay = path.getPath()).length < 3) continue;
                TimerTask task = (TimerTask)pathWay[pathWay.length - 1];
                results.add(task);
            }
        }
        return results;
    }

    public List<TimerTask> getSelectedElements() {
        ArrayList<TimerTask> results = new ArrayList<TimerTask>();
        TreePath[] paths = this.getTreeSelectionModel().getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                Object[] pathWay;
                if (path == null || (pathWay = path.getPath()).length < 2) continue;
                TimerTask task = (TimerTask)pathWay[pathWay.length - 1];
                results.add(task);
            }
        }
        return results;
    }

    public List<TimerProject> getSelectedProjects() {
        ArrayList<TimerProject> results = new ArrayList<TimerProject>();
        TreePath[] paths = this.getTreeSelectionModel().getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                Object[] pathWay;
                if (path == null || (pathWay = path.getPath()).length != 2) continue;
                TimerProject project = (TimerProject)pathWay[pathWay.length - 1];
                results.add(project);
            }
        }
        return results;
    }
}

