/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.tasks;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimer;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;

public class IdleDialog
extends JDialog {
    private static final long serialVersionUID = 7669429291708466753L;
    private static Log log = LogFactory.getLog(IdleDialog.class);
    protected static Object mutex = new Object();
    protected static IdleDialog idleDialog;
    protected static int lastResumeOption;
    protected SingleFrameApplication application;
    protected ResourceMap resourceMap;
    protected Timer timer;
    protected UpdateIdleTime updateIdleTime;
    protected long idleStartTimestamp;
    protected JLabel idleDurationLabel;
    public static final int REVERT = 0;
    public static final int CONTINUE = 1;
    public static final int RESUME = 2;

    protected IdleDialog(SingleFrameApplication application) {
        this.application = application;
        ApplicationContext ctxt = application.getContext();
        ResourceManager mgr = ctxt.getResourceManager();
        this.resourceMap = mgr.getResourceMap(IdleDialog.class);
        this.setName(null);
        this.setTitle(this.resourceMap.getString("idleTitle", new Object[0]));
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.getRootPane().setLayout(new BorderLayout(1, 1));
        this.getRootPane().add((Component)this.getMainComponent(), "Center");
        this.timer = new Timer();
    }

    private JComponent getMainComponent() {
        JPanel mainComponent = new JPanel(new GridBagLayout());
        JLabel idleIcon = new JLabel(this.resourceMap.getIcon("idleIcon"));
        mainComponent.add((Component)idleIcon, new GridBagConstraints(0, 0, 1, 5, 0.0, 1.0, 11, 0, new Insets(10, 5, 10, 10), 0, 0));
        JLabel idleLabel = new JLabel(this.resourceMap.getString("idleMessage", new Object[]{JTimer.config.getIdleTime() / 60L}));
        mainComponent.add((Component)idleLabel, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 3), 0, 0));
        this.idleDurationLabel = new JLabel(" ");
        mainComponent.add((Component)this.idleDurationLabel, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 3, 5), 0, 0));
        mainComponent.add((Component)new JSeparator(), new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        JLabel idleRestart = new JLabel(this.resourceMap.getString("idleRestart", new Object[0]));
        mainComponent.add((Component)idleRestart, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 5), 0, 0));
        JButton revertButton = new JButton();
        revertButton.setHorizontalAlignment(2);
        revertButton.setAction(this.application.getContext().getActionMap((Object)this).get((Object)"chooseRevertOption"));
        mainComponent.add((Component)revertButton, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 5, 5), 0, 0));
        JButton continueButton = new JButton();
        continueButton.setHorizontalAlignment(2);
        continueButton.setAction(this.application.getContext().getActionMap((Object)this).get((Object)"chooseContinueOption"));
        mainComponent.add((Component)continueButton, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 5, 5), 0, 0));
        JButton resumeButton = new JButton();
        resumeButton.setHorizontalAlignment(2);
        resumeButton.setAction(this.application.getContext().getActionMap((Object)this).get((Object)"chooseResumeOption"));
        mainComponent.add((Component)resumeButton, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 5, 5), 0, 0));
        return mainComponent;
    }

    public static void init(SingleFrameApplication parent) {
        idleDialog = new IdleDialog(parent);
    }

    @Action
    public void chooseRevertOption() {
        lastResumeOption = 0;
        this.idleEnded();
    }

    @Action
    public void chooseContinueOption() {
        lastResumeOption = 1;
        this.idleEnded();
    }

    @Action
    public void chooseResumeOption() {
        lastResumeOption = 2;
        this.idleEnded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void idleEnded() {
        Object object = mutex;
        synchronized (object) {
            mutex.notifyAll();
        }
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.updateIdleTime = new UpdateIdleTime();
            this.timer.schedule((TimerTask)this.updateIdleTime, 0L, 60000L);
        } else {
            this.updateIdleTime.cancel();
            this.timer.purge();
        }
        super.setVisible(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showIdleDialog(long idleStartTimestamp) {
        boolean mustShow = false;
        Object object = idleDialog;
        synchronized (object) {
            mustShow = !idleDialog.isVisible();
        }
        if (mustShow) {
            IdleDialog.idleDialog.idleStartTimestamp = idleStartTimestamp;
            IdleDialog.idleDialog.application.show((JDialog)idleDialog);
        } else {
            object = mutex;
            synchronized (object) {
                block10: {
                    try {
                        mutex.wait();
                    }
                    catch (InterruptedException e) {
                        if (!log.isErrorEnabled()) break block10;
                        log.error((Object)"Thread inturrupted", (Throwable)e);
                    }
                }
            }
        }
        return lastResumeOption;
    }

    protected class UpdateIdleTime
    extends TimerTask {
        protected UpdateIdleTime() {
        }

        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Update idle duration");
            }
            String duration = DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - IdleDialog.this.idleStartTimestamp), (String)"HH:mm");
            IdleDialog.this.idleDurationLabel.setText(IdleDialog.this.resourceMap.getString("idleDuration", new Object[]{duration}));
        }
    }
}

