/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.system;

import com.sun.jna.Platform;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.ui.system.SystemInfo;
import org.chorem.jtimer.ui.system.UnsupportedSystemInfoException;
import org.chorem.jtimer.ui.system.macos.MacOSSystemInfo;
import org.chorem.jtimer.ui.system.unix.UnixSystemInfo;
import org.chorem.jtimer.ui.system.win32.Win32SystemInfo;

public class SystemInfoFactory {
    private static Log log = LogFactory.getLog(SystemInfoFactory.class);
    protected static SystemInfo instance;

    protected SystemInfoFactory() {
    }

    public static SystemInfo getSystemInfo() throws UnsupportedSystemInfoException {
        if (instance == null) {
            String os = System.getProperty("os.name");
            if (log.isInfoEnabled()) {
                log.info((Object)("Try do build system info for system : " + os));
            }
            if (Platform.isWindows()) {
                instance = new Win32SystemInfo();
            } else if (Platform.isLinux()) {
                instance = new UnixSystemInfo();
            } else if (Platform.isMac()) {
                instance = new MacOSSystemInfo();
            } else {
                throw new UnsupportedSystemInfoException("Can't get system info for " + os);
            }
        }
        return instance;
    }
}

