/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.report;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimer;
import org.chorem.jtimer.data.TimerCore;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.ui.report.ReportGenerator;
import org.chorem.jtimer.ui.report.tree.CheckBoxTreeCellEditor;
import org.chorem.jtimer.ui.report.tree.CheckBoxTreeCellRenderer;
import org.chorem.jtimer.ui.report.tree.CheckBoxTreeModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.View;
import org.jdesktop.swingx.JXDatePicker;

public class ReportView
extends FrameView
implements DocumentListener {
    protected static Log log = LogFactory.getLog(ReportView.class);
    protected TimerCore core;
    protected Set<TimerTask> uncheckedTaskSet;
    protected JRadioButton radioByDay;
    protected JRadioButton radioByMonth;
    protected JRadioButton radioByWeek;
    protected JRadioButton radioByYear;
    protected JRadioButton radioByProject;
    protected JCheckBox checkIncludesAnnotations;
    protected JCheckBox checkIncludesAnnotationsTime;
    protected JXDatePicker datePickerFrom;
    protected JXDatePicker datePickerTo;
    protected JTree projectsTree;
    protected JCheckBox showHiddenProjectBox;
    protected ReportGenerator reportGenerator;
    protected JTextArea reportArea;
    protected boolean canSendMail;

    public ReportView(Application application, TimerCore core) {
        super(application);
        this.getFrame().setName("reportFrame");
        this.core = core;
        this.uncheckedTaskSet = new HashSet<TimerTask>();
        this.setComponent(this.getMainComponent());
        this.reportGenerator = new ReportGenerator();
    }

    protected JComponent getMainComponent() {
        JPanel configComponent = new JPanel(new GridBagLayout());
        JPanel panelOption = new JPanel(new GridBagLayout());
        panelOption.setBorder(BorderFactory.createTitledBorder(this.getResourceMap().getString("reportOptions", new Object[0])));
        JLabel labelFrom = new JLabel(this.getResourceMap().getString("reportFrom", new Object[0]));
        panelOption.add((Component)labelFrom, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.datePickerFrom = new JXDatePicker();
        this.datePickerFrom.getMonthView().setDayForeground(1, Color.RED);
        this.datePickerFrom.setFormats(new DateFormat[]{DateFormat.getDateInstance(0)});
        panelOption.add((Component)this.datePickerFrom, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JLabel labelTo = new JLabel(this.getResourceMap().getString("reportTo", new Object[0]));
        panelOption.add((Component)labelTo, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.datePickerTo = new JXDatePicker();
        this.datePickerTo.getMonthView().setDayForeground(1, Color.RED);
        this.datePickerTo.setFormats(new DateFormat[]{DateFormat.getDateInstance(0)});
        panelOption.add((Component)this.datePickerTo, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.currentWeek();
        JButton currentWeekButton = new JButton();
        currentWeekButton.setAction(this.getContext().getActionMap((Object)this).get((Object)"currentWeek"));
        panelOption.add((Component)currentWeekButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JButton previousWeekButton = new JButton();
        previousWeekButton.setAction(this.getContext().getActionMap((Object)this).get((Object)"previousWeek"));
        panelOption.add((Component)previousWeekButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.radioByDay = new JRadioButton(this.getResourceMap().getString("reportDaily", new Object[0]), true);
        this.radioByMonth = new JRadioButton(this.getResourceMap().getString("reportMonthly", new Object[0]));
        this.radioByWeek = new JRadioButton(this.getResourceMap().getString("reportWeekly", new Object[0]));
        this.radioByYear = new JRadioButton(this.getResourceMap().getString("reportYearly", new Object[0]));
        this.radioByProject = new JRadioButton(this.getResourceMap().getString("reportByProject", new Object[0]));
        ButtonGroup group = new ButtonGroup();
        group.add(this.radioByDay);
        group.add(this.radioByMonth);
        group.add(this.radioByWeek);
        group.add(this.radioByYear);
        group.add(this.radioByProject);
        panelOption.add((Component)this.radioByDay, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        panelOption.add((Component)this.radioByMonth, new GridBagConstraints(2, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        panelOption.add((Component)this.radioByWeek, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        panelOption.add((Component)this.radioByYear, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        panelOption.add((Component)this.radioByProject, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.checkIncludesAnnotations = new JCheckBox();
        this.checkIncludesAnnotations.setAction(this.getContext().getActionMap((Object)this).get((Object)"reportAnnotations"));
        panelOption.add((Component)this.checkIncludesAnnotations, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.checkIncludesAnnotationsTime = new JCheckBox(this.getResourceMap().getString("reportAnnotationsTime", new Object[0]));
        this.checkIncludesAnnotationsTime.setEnabled(false);
        panelOption.add((Component)this.checkIncludesAnnotationsTime, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JPanel panelProjects = new JPanel(new BorderLayout());
        panelProjects.setBorder(BorderFactory.createTitledBorder(this.getResourceMap().getString("reportProjects", new Object[0])));
        this.showHiddenProjectBox = new JCheckBox(this.getContext().getActionMap((Object)this).get((Object)"showHiddenProjects"));
        panelProjects.add((Component)this.showHiddenProjectBox, "North");
        this.projectsTree = new JTree();
        this.projectsTree.setRootVisible(true);
        this.projectsTree.setEditable(true);
        this.projectsTree.setModel(new CheckBoxTreeModel(this.core, this.getResourceMap().getString("reportProjectsList", new Object[0]) + " :"));
        this.projectsTree.setCellEditor(new CheckBoxTreeCellEditor(this.core, this.projectsTree, this.uncheckedTaskSet));
        this.projectsTree.setCellRenderer(new CheckBoxTreeCellRenderer(this.core, this.projectsTree, this.uncheckedTaskSet));
        JScrollPane jspTable = new JScrollPane(this.projectsTree);
        panelProjects.add((Component)jspTable, "Center");
        configComponent.add((Component)panelOption, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        configComponent.add((Component)panelProjects, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        JPanel panelReports = new JPanel(new GridBagLayout());
        panelReports.setBorder(BorderFactory.createTitledBorder(this.getResourceMap().getString("reportContent", new Object[0])));
        this.reportArea = new JTextArea();
        this.reportArea.setFont(new Font("Courier", 0, 12));
        this.reportArea.getDocument().addDocumentListener(this);
        JScrollPane jspReport = new JScrollPane(this.reportArea);
        panelReports.add((Component)jspReport, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        JButton generateButton = new JButton();
        generateButton.setAction(this.getContext().getActionMap((Object)this).get((Object)"generateReport"));
        panelReports.add((Component)generateButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JButton sendMailButton = new JButton();
        sendMailButton.setAction(this.getContext().getActionMap((Object)this).get((Object)"sendMail"));
        panelReports.add((Component)sendMailButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JButton closeButton = new JButton();
        closeButton.setAction(this.getContext().getActionMap((Object)this).get((Object)"closeView"));
        panelReports.add((Component)closeButton, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JSplitPane splitPane = new JSplitPane(1, configComponent, panelReports);
        splitPane.setOneTouchExpandable(true);
        return splitPane;
    }

    @Action
    public void currentWeek() {
        this.fillPickerDates(0);
    }

    @Action
    public void previousWeek() {
        this.fillPickerDates(-1);
    }

    protected void fillPickerDates(int delay) {
        Calendar calendarBegin = Calendar.getInstance();
        int firstDayOfWeek = JTimer.config.getReportFirstDayOfWeek();
        if (firstDayOfWeek <= 0 || firstDayOfWeek > 7) {
            firstDayOfWeek = calendarBegin.getFirstDayOfWeek();
        }
        calendarBegin.set(7, firstDayOfWeek);
        calendarBegin.set(10, 0);
        calendarBegin.set(12, 0);
        calendarBegin.set(13, 0);
        calendarBegin.set(14, 0);
        if (calendarBegin.getTime().after(new Date())) {
            calendarBegin.add(3, -1);
        }
        Calendar calendarEnd = (Calendar)calendarBegin.clone();
        calendarEnd.add(3, 1);
        calendarEnd.add(6, -1);
        calendarBegin.add(3, delay);
        calendarEnd.add(3, delay);
        this.datePickerFrom.setDate(calendarBegin.getTime());
        this.datePickerTo.setDate(calendarEnd.getTime());
    }

    @Action
    public void closeView() {
        this.getApplication().hide((View)this);
    }

    @Action
    public void reportAnnotations() {
        this.checkIncludesAnnotationsTime.setEnabled(this.checkIncludesAnnotations.isSelected());
    }

    @Action
    public void generateReport() {
        List<TimerProject> selectedProjects;
        ReportGenerator.Type reportType = null;
        reportType = this.radioByDay.isSelected() ? ReportGenerator.Type.BY_DAY_REPORT : (this.radioByMonth.isSelected() ? ReportGenerator.Type.BY_MONTH_REPORT : (this.radioByWeek.isSelected() ? ReportGenerator.Type.BY_WEEK_REPORT : (this.radioByYear.isSelected() ? ReportGenerator.Type.BY_YEAR_REPORT : ReportGenerator.Type.BY_PROJECT_REPORT)));
        String report = this.reportGenerator.getReportText(reportType, selectedProjects = this.getSelectedProjects(this.core.getData().getProjectsList(), this.uncheckedTaskSet), this.datePickerFrom.getDate(), this.datePickerTo.getDate(), this.checkIncludesAnnotations.isSelected(), this.checkIncludesAnnotationsTime.isSelected());
        if (report != null && !report.isEmpty()) {
            this.reportArea.setText(report);
        } else {
            this.reportArea.setText("");
        }
    }

    protected List<TimerProject> getSelectedProjects(List<TimerProject> projects, Collection<TimerTask> uncheckedTaskList) {
        ArrayList<TimerProject> currentProjects = new ArrayList<TimerProject>();
        for (TimerProject project : projects) {
            if (project.isClosed() && !this.showHiddenProjectBox.isSelected()) continue;
            List<TimerTask> subTasks = this.getSelectedTasks(project.getSubTasks(), uncheckedTaskList);
            if (uncheckedTaskList.contains(project) && subTasks.isEmpty()) continue;
            TimerProject clonedProject = project.clone();
            clonedProject.getSubTasks().clear();
            clonedProject.getSubTasks().addAll(subTasks);
            currentProjects.add(clonedProject);
        }
        return currentProjects;
    }

    protected List<TimerTask> getSelectedTasks(List<? extends TimerTask> tasks, Collection<TimerTask> uncheckedTaskList) {
        ArrayList<TimerTask> currentTask = new ArrayList<TimerTask>();
        for (TimerTask timerTask : tasks) {
            if (timerTask.isClosed() && !this.showHiddenProjectBox.isSelected()) continue;
            List<TimerTask> subTasks = this.getSelectedTasks(timerTask.getSubTasks(), uncheckedTaskList);
            if (uncheckedTaskList.contains(timerTask) && subTasks.isEmpty()) continue;
            TimerTask clonedTask = uncheckedTaskList.contains(timerTask) ? new TimerTask(timerTask.getName()) : timerTask.clone();
            clonedTask.getSubTasks().clear();
            clonedTask.getSubTasks().addAll(subTasks);
            currentTask.add(clonedTask);
        }
        return currentTask;
    }

    @Action
    public void showHiddenProjects() {
        CheckBoxTreeModel model = (CheckBoxTreeModel)this.projectsTree.getModel();
        model.setShowClosed(this.showHiddenProjectBox.isSelected());
    }

    @Action(enabledProperty="sendMailEnabled")
    public void sendMail() {
        block8: {
            String report = this.reportArea.getText();
            try {
                String encodedReport = URLEncoder.encode(report, "UTF-8");
                encodedReport = encodedReport.replaceAll("\\+", "%20");
                URI mailtoURI = new URI("mailto:?body=" + encodedReport);
                Desktop.getDesktop().mail(mailtoURI);
            }
            catch (IOException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Cannot open link (maybe defaut browser in not configured ?)");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Error while opening link", (Throwable)e);
                }
            }
            catch (URISyntaxException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Error while opening link", (Throwable)e);
                }
            }
            catch (UnsupportedOperationException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Cannot open link (maybe defaut browser in not configured ?)");
                }
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)"Error while opening link", (Throwable)e);
            }
        }
    }

    public boolean isSendMailEnabled() {
        return this.canSendMail;
    }

    public void setSendMailEnabled(boolean enabled) {
        boolean oldValue = this.canSendMail;
        this.canSendMail = enabled;
        this.firePropertyChange("sendMailEnabled", oldValue, this.canSendMail);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    protected void documentChanged() {
        this.setSendMailEnabled(this.reportArea.getText().trim().length() > 0);
    }
}

