/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.View;

public class HelpFrame
extends FrameView
implements HyperlinkListener {
    private static Log log = LogFactory.getLog(HelpFrame.class);

    public HelpFrame(Application application) {
        super(application);
        this.getFrame().setName("helpFrame");
        this.getFrame().setTitle(this.getResourceMap().getString("aboutTitle", new Object[0]));
        this.setComponent(this.getMainComponent());
    }

    protected JComponent getMainComponent() {
        JPanel mainComponent = new JPanel(new GridBagLayout());
        Icon logoIcon = this.getResourceMap().getIcon("aboutIcon");
        JLabel labelIcon = new JLabel(logoIcon);
        mainComponent.add((Component)labelIcon, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JTabbedPane tabPanel = new JTabbedPane();
        Component firstTab = this.getAboutTab();
        tabPanel.add(this.getResourceMap().getString("aboutHtmlTitle", new Object[0]), firstTab);
        Component secondTab = this.getLicenseTab();
        tabPanel.add(this.getResourceMap().getString("aboutLicenseTitle", new Object[0]), secondTab);
        mainComponent.add((Component)tabPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JButton closeButton = new JButton();
        closeButton.setAction(this.getContext().getActionMap((Object)this).get((Object)"closeView"));
        mainComponent.add((Component)closeButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 20, 0));
        this.getFrame().setResizable(false);
        mainComponent.setBackground(Color.WHITE);
        return mainComponent;
    }

    protected Component getLicenseTab() {
        JTextArea licenseArea = new JTextArea();
        licenseArea.setLineWrap(true);
        licenseArea.setWrapStyleWord(true);
        licenseArea.setText(this.getResourceMap().getString("aboutLicense", new Object[0]));
        licenseArea.setEditable(false);
        return licenseArea;
    }

    protected Component getAboutTab() {
        JEditorPane htmlAbout = new JEditorPane("text/html", this.getResourceMap().getString("aboutHtml", new Object[0]));
        htmlAbout.addHyperlinkListener(this);
        htmlAbout.setEditable(false);
        return htmlAbout;
    }

    @Action
    public void closeView() {
        this.getApplication().hide((View)this);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent he) {
        block9: {
            if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                try {
                    URL u = he.getURL();
                    if (u.getProtocol().equalsIgnoreCase("mailto") || u.getProtocol().equalsIgnoreCase("http") || u.getProtocol().equalsIgnoreCase("ftp")) {
                        Desktop.getDesktop().browse(u.toURI());
                    }
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error while opening link", (Throwable)e);
                    }
                }
                catch (URISyntaxException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error while opening link", (Throwable)e);
                    }
                }
                catch (UnsupportedOperationException e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Cannot open link (maybe defaut browser in not configured ?)");
                    }
                    if (!log.isDebugEnabled()) break block9;
                    log.debug((Object)"Error while opening link", (Throwable)e);
                }
            }
        }
    }
}

