/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.io;

import java.io.File;
import java.io.IOException;
import java.util.TimerTask;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.io.GTimerIncrementalSaver;
import org.chorem.jtimer.io.Saver;

public abstract class AbstractSaver
extends TimerTask
implements Saver {
    private static Log log = LogFactory.getLog(GTimerIncrementalSaver.class);
    public static final String BACKUP_EXTENSION = ".tmp";

    protected File makeBackupFile(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        File backupFile = new File(file.getAbsoluteFile() + BACKUP_EXTENSION);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Backuping file " + file.getName() + " to " + backupFile.getName()));
        }
        backupFile.delete();
        FileUtils.copyFile((File)file, (File)backupFile);
        return backupFile;
    }

    protected boolean restoreBackupFile(File backupFile) {
        String fileName = backupFile.getAbsolutePath();
        if (!fileName.endsWith(BACKUP_EXTENSION)) {
            throw new IllegalArgumentException("Not a valid backup file" + backupFile);
        }
        fileName = fileName.substring(0, fileName.length() - BACKUP_EXTENSION.length());
        File file = new File(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Renaming " + backupFile.getName() + " to " + file.getName()));
        }
        boolean done = backupFile.renameTo(file);
        return done;
    }

    protected void deleteBackupFile(File backupFile) {
        if (backupFile != null) {
            backupFile.delete();
        }
    }
}

