/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.data;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.DataViolationException;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.data.VetoableDataEventListener;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.entities.TimerTaskHelper;

public class CommonVetoable
implements VetoableDataEventListener {
    private static Log log = LogFactory.getLog(CommonVetoable.class);
    protected static final String DUPLICATED_PROJECT_VIOLATION = "vetoable.common.duplicated.project.name";
    protected static final String DUPLICATED_TASK_VIOLATION = "vetoable.common.duplicated.task.name";
    protected static final String MOVE_INVALID_TYPES_VIOLATION = "vetoable.common.move.invalid.types";
    protected static final String MERGE_INVALID_TYPES_VIOLATION = "vetoable.common.merge.invalid.types";
    protected TimerDataManager manager;

    public CommonVetoable(TimerDataManager manager) {
        this.manager = manager;
    }

    protected boolean isSameTaskName(TimerTask task, List<? extends TimerTask> tasks) {
        boolean found = false;
        for (TimerTask timerTask : tasks) {
            if (!timerTask.getName().equals(task.getName())) continue;
            found = true;
        }
        return found;
    }

    @Override
    public void checkAddProject(TimerProject project) {
        if (this.isSameTaskName(project, this.manager.getProjectsList())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Duplicated name, checkAddProject won't pass");
            }
            throw new DataViolationException("Can't add project", DUPLICATED_PROJECT_VIOLATION);
        }
    }

    @Override
    public void checkAddTask(TimerTask parent, TimerTask task) {
        if (this.isSameTaskName(task, parent.getSubTasks())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Duplicated name, checkAddTask won't pass");
            }
            throw new DataViolationException("Can't add task", DUPLICATED_TASK_VIOLATION);
        }
    }

    @Override
    public void checkChangeClosedState(TimerTask task) {
    }

    @Override
    public void checkDeleteProject(TimerProject project) {
    }

    @Override
    public void checkDeleteTask(TimerTask task) {
    }

    @Override
    public void checkModifyProject(TimerProject project) {
        if (this.isSameTaskName(project, this.manager.getProjectsList())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Duplicated name, checkModifyProject won't pass");
            }
            throw new DataViolationException("Can't modify project", DUPLICATED_PROJECT_VIOLATION);
        }
    }

    @Override
    public void checkModifyTask(TimerTask task) {
        if (this.isSameTaskName(task, task.getSubTasks())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Duplicated name, checkModifyTask won't pass");
            }
            throw new DataViolationException("Can't modify task", DUPLICATED_TASK_VIOLATION);
        }
    }

    @Override
    public void checkMoveTask(TimerTask destination, Collection<TimerTask> tasksToMove) {
        if (TimerTaskHelper.collectionContainsTask(tasksToMove, destination)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Move task into himself, impossible");
            }
            throw new DataViolationException("Can't move task into himself", MOVE_INVALID_TYPES_VIOLATION);
        }
        for (TimerTask taskToMove : tasksToMove) {
            if (taskToMove instanceof TimerProject) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Move project, impossible");
                }
                throw new DataViolationException("Can't move project", MOVE_INVALID_TYPES_VIOLATION);
            }
            if (!this.isSameTaskName(taskToMove, destination.getSubTasks())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Duplicated name, checkMoveTask won't pass");
            }
            throw new DataViolationException("Can't move task", DUPLICATED_TASK_VIOLATION);
        }
    }

    @Override
    public void checkSetAnnotation(TimerTask task, Date date, String value) {
    }

    @Override
    public void checkSetTaskTime(TimerTask task, Date date, Long value) {
    }

    @Override
    public void checkMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
        if (destinationTask instanceof TimerProject) {
            for (TimerTask otherTask : otherTasks) {
                if (otherTask instanceof TimerProject) continue;
                throw new DataViolationException("Can't merge task", MERGE_INVALID_TYPES_VIOLATION);
            }
        } else {
            for (TimerTask otherTask : otherTasks) {
                if (!(otherTask instanceof TimerProject)) continue;
                throw new DataViolationException("Can't merge task", MERGE_INVALID_TYPES_VIOLATION);
            }
        }
    }
}

