/*
 * #%L
 * jTimer
 * 
 * $Id: MacOSSystemInfo.java 2778 2011-09-05 08:12:54Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.jtimer.ui.system.macos;

import org.chorem.jtimer.ui.system.SystemInfo;

/**
 * MacOSSystemInfo
 * 
 * Source : http://ochafik.free.fr/blog/?p=98#comment-17694
 * 
 * @author chatellier
 * @version $Revision: 2778 $
 * @since 1.3.2
 * 
 * Last update : $Date: 2011-09-05 10:12:54 +0200 (Mon, 05 Sep 2011) $
 * By : $Author: chatellier $
 */
public class MacOSSystemInfo implements SystemInfo {

    /*
     * @see org.chorem.jtimer.ui.system.SystemInfo#getIdleTime()
     */
    @Override
    public long getIdleTime() {
        double idleTimeSeconds = ApplicationServices.INSTANCE
                .CGEventSourceSecondsSinceLastEventType(
                        ApplicationServices.kCGEventSourceStateCombinedSessionState,
                        ApplicationServices.kCGAnyInputEventType);
        return (long) (idleTimeSeconds * 1000);
    }

}
