/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ws.xmlrpc;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.ConnectionData;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.ws.ConnectionDataHandler;
import org.chorem.jtimer.ws.exception.WebServiceException;
import org.chorem.jtimer.ws.xmlrpc.ChoremXMLRPCClient;

public class WSDaemon
extends java.util.TimerTask {
    private static Log log = LogFactory.getLog(WSDaemon.class);
    protected TimerDataManager dataManager;
    protected ChoremXMLRPCClient managementService;
    protected ConnectionDataHandler connectionDataHandler;

    public WSDaemon(ChoremXMLRPCClient managementService, TimerDataManager dataManager) {
        this.dataManager = dataManager;
        this.managementService = managementService;
    }

    public void setConnectionDataHandler(ConnectionDataHandler connectionDataHandler) {
        this.connectionDataHandler = connectionDataHandler;
    }

    @Override
    public void run() {
        block15: {
            if (this.connectionDataHandler == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No handler set, can't synchronize");
                }
                return;
            }
            ConnectionData cData = this.connectionDataHandler.getConnectionInformation(this.managementService);
            if (cData != null) {
                String login = cData.getLogin();
                if (log.isInfoEnabled()) {
                    log.info((Object)"Refresh...");
                }
                try {
                    String userId = this.managementService.login(login, "");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("UserId = " + userId));
                    }
                    if (userId == null || userId.isEmpty()) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"TODO : Unknown user identifier, should reask here");
                        }
                    } else {
                        this.refreshProjectList(userId);
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Project list refreshed");
                        }
                        this.managementService.synchronize(userId, this.dataManager.getProjectsList());
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Times updated");
                        }
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Refresh complete");
                        }
                    }
                    break block15;
                }
                catch (WebServiceException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't synchronize with remote service", (Throwable)e);
                    }
                    break block15;
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Can't do synchronization");
            }
        }
    }

    protected void refreshProjectList(String userId) {
        block5: {
            try {
                List<TimerProject> projects = this.managementService.getUserProjects(userId);
                if (projects != null) {
                    for (TimerProject project : projects) {
                        String projectName = project.getName();
                        TimerProject localProject = this.getProjectByName(projectName);
                        if (localProject != null) {
                            this.synchronizeTask(localProject, project);
                            continue;
                        }
                        this.dataManager.addProject(project);
                    }
                }
            }
            catch (WebServiceException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Can't synchronize with remote service", (Throwable)e);
            }
        }
    }

    protected TimerProject getProjectByName(String projectName) {
        TimerProject projectFound = null;
        for (TimerProject project : this.dataManager.getProjectsList()) {
            if (!project.getName().equals(projectName)) continue;
            projectFound = project;
        }
        return projectFound;
    }

    protected TimerTask getTaskByName(TimerTask task, String taskName) {
        TimerTask taskFound = null;
        for (TimerTask lTask : task.getSubTasks()) {
            if (!lTask.getName().equals(taskName)) continue;
            taskFound = lTask;
        }
        return taskFound;
    }

    protected void synchronizeTask(TimerTask localTask, TimerTask task) {
        for (TimerTask lTask : task.getSubTasks()) {
            TimerTask localTaskFound = this.getTaskByName(localTask, lTask.getName());
            if (localTaskFound != null) {
                this.synchronizeTask(localTaskFound, lTask);
                continue;
            }
            this.dataManager.addTask(localTask, lTask);
        }
    }
}

