/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.utils;

import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;

public class DailySortedMap<T>
extends TreeMap<Date, T> {
    private static final long serialVersionUID = 5736472379626976185L;

    public DailySortedMap() {
    }

    public DailySortedMap(Comparator<? super Date> comparator) {
        super(comparator);
    }

    public DailySortedMap(Map<? extends Date, ? extends T> m) {
        super(m);
    }

    public DailySortedMap(SortedMap<Date, ? extends T> m) {
        super(m);
    }

    @Override
    public Map.Entry<Date, T> ceilingEntry(Date key) {
        Date dayKey = this.getDayDate(key);
        Map.Entry result = super.ceilingEntry(dayKey);
        return result;
    }

    @Override
    public Date ceilingKey(Date key) {
        Date dayKey = this.getDayDate(key);
        Date result = super.ceilingKey(dayKey);
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean result = false;
        if (key instanceof Date) {
            Date lDate = this.getDayDate((Date)key);
            result = super.containsKey(lDate);
        }
        return result;
    }

    @Override
    public Map.Entry<Date, T> floorEntry(Date key) {
        Date dayKey = this.getDayDate(key);
        Map.Entry result = super.floorEntry(dayKey);
        return result;
    }

    @Override
    public Date floorKey(Date key) {
        Date dayKey = this.getDayDate(key);
        Date result = super.floorKey(dayKey);
        return result;
    }

    @Override
    public T get(Object key) {
        T result = null;
        if (key instanceof Date) {
            Date lDate = this.getDayDate((Date)key);
            result = (T)super.get(lDate);
        }
        return result;
    }

    @Override
    public NavigableMap<Date, T> headMap(Date toKey, boolean inclusive) {
        Date dayKey = this.getDayDate(toKey);
        NavigableMap result = super.headMap(dayKey, inclusive);
        return result;
    }

    @Override
    public SortedMap<Date, T> headMap(Date toKey) {
        Date dayKey = this.getDayDate(toKey);
        SortedMap result = super.headMap(dayKey);
        return result;
    }

    @Override
    public Map.Entry<Date, T> higherEntry(Date key) {
        Date dayKey = this.getDayDate(key);
        Map.Entry result = super.higherEntry(dayKey);
        return result;
    }

    @Override
    public Date higherKey(Date key) {
        Date dayKey = this.getDayDate(key);
        Date result = super.higherKey(dayKey);
        return result;
    }

    @Override
    public Map.Entry<Date, T> lowerEntry(Date key) {
        Date dayKey = this.getDayDate(key);
        Map.Entry result = super.lowerEntry(dayKey);
        return result;
    }

    @Override
    public Date lowerKey(Date key) {
        Date dayKey = this.getDayDate(key);
        Date result = super.lowerKey(dayKey);
        return result;
    }

    @Override
    public T put(Date key, T value) {
        Date lDate = this.getDayDate(key);
        T result = super.put(lDate, value);
        return result;
    }

    @Override
    public void putAll(Map<? extends Date, ? extends T> map) {
        for (Map.Entry<Date, T> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public NavigableMap<Date, T> subMap(Date fromKey, boolean fromInclusive, Date toKey, boolean toInclusive) {
        Date fromDayKey = this.getDayDate(fromKey);
        Date toDayKey = this.getDayDate(toKey);
        NavigableMap result = super.subMap(fromDayKey, fromInclusive, toDayKey, toInclusive);
        return result;
    }

    @Override
    public SortedMap<Date, T> subMap(Date fromKey, Date toKey) {
        Date fromDayKey = this.getDayDate(fromKey);
        Date toDayKey = this.getDayDate(toKey);
        SortedMap result = super.subMap(fromDayKey, toDayKey);
        return result;
    }

    @Override
    public NavigableMap<Date, T> tailMap(Date fromKey, boolean inclusive) {
        Date fromDayKey = this.getDayDate(fromKey);
        NavigableMap result = super.tailMap(fromDayKey, inclusive);
        return result;
    }

    @Override
    public SortedMap<Date, T> tailMap(Date fromKey) {
        Date fromDayKey = this.getDayDate(fromKey);
        SortedMap result = super.tailMap(fromDayKey);
        return result;
    }

    protected Date getDayDate(Date date) {
        Date ldate = (Date)date.clone();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(ldate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date result = calendar.getTime();
        return result;
    }
}

