/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.widget;

import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DurationEditor
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -5395307807542911835L;
    protected JSpinner hourSpinner;
    protected JSpinner minuteSpinner;
    protected JSpinner secondSpinner;
    protected SpinnerNumberModel hourSpinnerModel;
    protected SpinnerNumberModel minuteSpinnerModel;
    protected SpinnerNumberModel secondSpinnerModel;
    protected long duration;

    public DurationEditor() {
        this(24);
    }

    public DurationEditor(int maxHourValue) {
        super(new FlowLayout(1, 0, 0));
        this.hourSpinnerModel = new SpinnerNumberModel(0, 0, maxHourValue, 1);
        this.hourSpinner = new JSpinner(this.hourSpinnerModel);
        this.add(this.hourSpinner);
        this.add(new JLabel(":"));
        this.minuteSpinnerModel = new SpinnerNumberModel(0, -1, 60, 1);
        this.minuteSpinner = new JSpinner(this.minuteSpinnerModel);
        this.add(this.minuteSpinner);
        this.add(new JLabel(":"));
        this.secondSpinnerModel = new SpinnerNumberModel(0, -1, 60, 1);
        this.secondSpinner = new JSpinner(this.secondSpinnerModel);
        this.add(this.secondSpinner);
        this.hourSpinnerModel.addChangeListener(this);
        this.minuteSpinnerModel.addChangeListener(this);
        this.secondSpinnerModel.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value;
        if (e.getSource() == this.minuteSpinnerModel) {
            value = this.minuteSpinnerModel.getNumber().intValue();
            if (value >= 60) {
                if (this.hourSpinnerModel.getNextValue() != null) {
                    this.minuteSpinnerModel.setValue(value - 60);
                    this.hourSpinnerModel.setValue(this.hourSpinnerModel.getNextValue());
                } else {
                    this.minuteSpinnerModel.setValue(value - 1);
                }
            } else if (value < 0) {
                if (this.hourSpinnerModel.getPreviousValue() != null) {
                    this.minuteSpinnerModel.setValue(value + 60);
                    this.hourSpinnerModel.setValue(this.hourSpinnerModel.getPreviousValue());
                } else {
                    this.minuteSpinnerModel.setValue(value + 1);
                }
            }
        } else if (e.getSource() == this.secondSpinnerModel) {
            value = this.secondSpinnerModel.getNumber().intValue();
            if (value >= 60) {
                if (this.minuteSpinnerModel.getNextValue() != null) {
                    this.secondSpinnerModel.setValue(value - 60);
                    this.minuteSpinnerModel.setValue(this.minuteSpinnerModel.getNextValue());
                } else {
                    this.secondSpinnerModel.setValue(value - 1);
                }
            } else if (value < 0) {
                if (this.hourSpinnerModel.getNumber().intValue() > 0 || this.minuteSpinnerModel.getNumber().intValue() > 0) {
                    this.secondSpinnerModel.setValue(value + 60);
                    this.minuteSpinnerModel.setValue(this.minuteSpinnerModel.getPreviousValue());
                } else {
                    this.secondSpinnerModel.setValue(value + 1);
                }
            }
        }
        long oldDuration = this.duration;
        this.duration = this.getDuration();
        this.firePropertyChange("duration", oldDuration, this.duration);
    }

    public long getDuration() {
        long modelDuration = 0L;
        modelDuration += this.hourSpinnerModel.getNumber().longValue() * 3600L;
        modelDuration += this.minuteSpinnerModel.getNumber().longValue() * 60L;
        return modelDuration += this.secondSpinnerModel.getNumber().longValue();
    }

    public void setDuration(long duration) {
        this.duration = duration;
        long localDuration = duration;
        this.hourSpinnerModel.setValue((int)(localDuration / 3600L));
        this.minuteSpinnerModel.setValue((int)((localDuration %= 3600L) / 60L));
        this.secondSpinnerModel.setValue((int)(localDuration %= 60L));
    }
}

