/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.DataEventListener;
import org.chorem.jtimer.data.TimerCore;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.jdesktop.swingx.JXTreeTable;

public class ProjectsAndTasksCellRenderer
extends DefaultTreeCellRenderer
implements DataEventListener {
    private static final long serialVersionUID = 1383276150996517529L;
    private static Log log = LogFactory.getLog(ProjectsAndTasksCellRenderer.class);
    protected ImageIcon runningIcon;
    protected Collection<TimerTask> runningTasks;
    protected JXTreeTable treeTable;
    protected NodeImageObserver nodeObserver;

    public ProjectsAndTasksCellRenderer(JXTreeTable treeTable, TimerCore core) {
        this.treeTable = treeTable;
        this.runningTasks = new HashSet<TimerTask>();
        URL runnigIconUrl = ProjectsAndTasksCellRenderer.class.getResource("/org/chorem/jtimer/resources/running.gif");
        this.runningIcon = new ImageIcon(runnigIconUrl);
        this.nodeObserver = new NodeImageObserver();
        this.runningIcon.setImageObserver(this.nodeObserver);
        core.getData().addDataEventListener(this);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TimerTask task;
        Object localValue = value;
        if (value instanceof TimerTask) {
            task = (TimerTask)value;
            String taskName = task.getName();
            if (task instanceof TimerProject && ((TimerProject)task).isSynchronized()) {
                taskName = taskName.substring("#".length());
            }
            localValue = taskName;
        }
        super.getTreeCellRendererComponent(tree, localValue, selected, expanded, leaf, row, hasFocus);
        if (value instanceof TimerTask) {
            task = (TimerTask)value;
            if (task instanceof TimerProject && ((TimerProject)task).isSynchronized()) {
                this.setFont(this.getFont().deriveFont(2));
            } else {
                this.setFont(this.getFont().deriveFont(0));
            }
            if (this.runningTasks.contains(task)) {
                this.setIcon(this.runningIcon);
                this.nodeObserver.addRow(row);
            } else {
                this.setIcon(null);
                this.nodeObserver.removeRow(row);
            }
            if (task.isClosed()) {
                if (selected) {
                    this.setForeground(Color.GRAY.brighter());
                } else {
                    this.setForeground(Color.GRAY);
                }
            }
        }
        return this;
    }

    @Override
    public void addProject(TimerProject project) {
    }

    @Override
    public void addTask(TimerTask task) {
    }

    @Override
    public void dataLoaded(Collection<TimerProject> projects) {
    }

    @Override
    public void deleteProject(TimerProject project) {
    }

    @Override
    public void deleteTask(TimerTask task) {
    }

    @Override
    public void modifyProject(TimerProject project) {
    }

    @Override
    public void modifyTask(TimerTask task) {
    }

    @Override
    public void changeClosedState(TimerTask task) {
    }

    @Override
    public void startTask(TimerTask task) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("startTask on " + task.getName()));
        }
        this.runningTasks.add(task);
    }

    @Override
    public void stopTask(TimerTask task) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("stopTask on " + task.getName()));
        }
        this.runningTasks.remove(task);
    }

    @Override
    public void moveTask(TimerTask task) {
    }

    @Override
    public void preMoveTask(TimerTask task) {
    }

    @Override
    public void postMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }

    @Override
    public void preMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }

    @Override
    public void setTaskTime(TimerTask task, Date date, Long time) {
    }

    @Override
    public void setAnnotation(TimerTask task, Date date, String annotation) {
    }

    class NodeImageObserver
    implements ImageObserver {
        protected Set<Integer> rows = Collections.synchronizedSet(new HashSet());

        NodeImageObserver() {
        }

        public void addRow(Integer row) {
            this.rows.add(row);
        }

        public void removeRow(Integer row) {
            this.rows.remove(row);
        }

        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
            if ((flags & 0x30) != 0) {
                for (Integer row : this.rows) {
                    Rectangle rowBounds = ProjectsAndTasksCellRenderer.this.treeTable.getCellRect(row.intValue(), 0, true);
                    if (rowBounds == null) continue;
                    ProjectsAndTasksCellRenderer.this.treeTable.repaint(rowBounds);
                }
            }
            return (flags & 0xA0) == 0;
        }
    }
}

