/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.system.unix;

import com.sun.jna.platform.unix.X11;
import com.sun.jna.ptr.IntByReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.ui.system.SystemInfo;
import org.chorem.jtimer.ui.system.unix.Xss;

public class UnixSystemInfo
implements SystemInfo {
    private static Log log = LogFactory.getLog(UnixSystemInfo.class);

    @Override
    public long getIdleTime() {
        long idleTime = 0L;
        try {
            idleTime = this.getXssIdleTime();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't detect idle time : ", (Throwable)e);
            }
            idleTime = 0L;
        }
        return idleTime;
    }

    protected long getXssIdleTime() {
        long idleTime = 0L;
        X11.Display display = X11.INSTANCE.XOpenDisplay(null);
        if (display == null) {
            log.error((Object)"Can't open X11 display");
        } else {
            IntByReference eventBase = new IntByReference();
            IntByReference errorBase = new IntByReference();
            if (!Xss.INSTANCE.XScreenSaverQueryExtension(display, eventBase, errorBase)) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't find xscreensaver extension, idle time can't be detected");
                }
            } else {
                Xss.XScreenSaverInfo screenSaverInfo = Xss.INSTANCE.XScreenSaverAllocInfo();
                if (screenSaverInfo == null) {
                    log.error((Object)"Could not alloc screen saver info");
                } else {
                    X11.Window rootWindow = X11.INSTANCE.XDefaultRootWindow(display);
                    if (rootWindow == null) {
                        log.error((Object)"Could not query root window");
                    } else {
                        screenSaverInfo.window = rootWindow;
                        Xss.INSTANCE.XScreenSaverQueryInfo(display, (X11.Drawable)rootWindow, screenSaverInfo);
                        if (screenSaverInfo.idle == null) {
                            log.error((Object)"screenSaverInfo.idle is null");
                        } else {
                            idleTime = screenSaverInfo.idle.longValue();
                        }
                    }
                    X11.INSTANCE.XFree(screenSaverInfo.getPointer());
                }
            }
            X11.INSTANCE.XCloseDisplay(display);
        }
        return idleTime;
    }
}

