/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.data;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.DataEventListener;
import org.chorem.jtimer.data.VetoableDataEventListener;
import org.chorem.jtimer.entities.TimerAlert;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;

public class TimerDataManager {
    private static Log log = LogFactory.getLog(TimerDataManager.class);
    protected List<TimerProject> projectList = new ArrayList<TimerProject>();
    protected Collection<DataEventListener> dataEventListeners = new ArrayList<DataEventListener>();
    protected Collection<VetoableDataEventListener> vetoableDataEventListeners = new ArrayList<VetoableDataEventListener>();

    public void addDataEventListener(DataEventListener listener) {
        this.dataEventListeners.add(listener);
    }

    public void removeDataEventListener(DataEventListener listener) {
        this.dataEventListeners.remove(listener);
    }

    public void addVetoableDataEventListener(VetoableDataEventListener listener) {
        this.vetoableDataEventListeners.add(listener);
    }

    public void removeVetoableDataEventListener(VetoableDataEventListener listener) {
        this.vetoableDataEventListeners.remove(listener);
    }

    public void addProject(TimerProject project) {
        for (VetoableDataEventListener vetoableDataEventListener : this.vetoableDataEventListeners) {
            vetoableDataEventListener.checkAddProject(project);
        }
        this.projectList.add(project);
        for (DataEventListener dataEventListener : this.dataEventListeners) {
            dataEventListener.addProject(project);
        }
    }

    public void addTask(TimerTask parent, TimerTask task) {
        for (VetoableDataEventListener vetoableDataEventListener : this.vetoableDataEventListeners) {
            vetoableDataEventListener.checkAddTask(parent, task);
        }
        parent.addTask(task);
        for (DataEventListener dataEventListener : this.dataEventListeners) {
            dataEventListener.addTask(task);
        }
    }

    public void addAllProjects(Collection<TimerProject> projects) {
        if (projects != null) {
            this.projectList.clear();
            this.projectList.addAll(projects);
            for (DataEventListener dataEventListener : this.dataEventListeners) {
                dataEventListener.dataLoaded(projects);
            }
        }
    }

    public List<TimerProject> getProjectsList() {
        return this.projectList;
    }

    public void changeTaskTime(TimerTask task, Date date, long value) {
        for (VetoableDataEventListener vetoableDataEventListener : this.vetoableDataEventListeners) {
            vetoableDataEventListener.checkSetTaskTime(task, date, value);
        }
        task.setTime(date, value);
        for (DataEventListener dataEventListener : this.dataEventListeners) {
            dataEventListener.setTaskTime(task, date, value);
        }
    }

    public void startTask(TimerTask task) {
        for (DataEventListener dataEventListener : this.dataEventListeners) {
            dataEventListener.startTask(task);
        }
    }

    public void stopTask(TimerTask task) {
        for (DataEventListener dataEventListener : this.dataEventListeners) {
            dataEventListener.stopTask(task);
        }
    }

    public void deleteTask(TimerTask task) {
        for (VetoableDataEventListener vetoableDataEventListener : this.vetoableDataEventListeners) {
            vetoableDataEventListener.checkDeleteTask(task);
        }
        task.getParent().getSubTasks().remove(task);
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().deleteTask(task);
        }
    }

    public void deleteProject(TimerProject project) {
        for (VetoableDataEventListener vetoableDataEventListener : this.vetoableDataEventListeners) {
            vetoableDataEventListener.checkDeleteProject(project);
        }
        this.projectList.remove(project);
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().deleteProject(project);
        }
    }

    public void changeProjectCloseState(TimerProject project) {
        this.changeTaskCloseState(project);
    }

    public void changeTaskCloseState(TimerTask task) {
        for (VetoableDataEventListener vetoableDataEventListener : this.vetoableDataEventListeners) {
            vetoableDataEventListener.checkChangeClosedState(task);
        }
        task.setClosed(!task.isClosed());
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().changeClosedState(task);
        }
    }

    public void editProject(TimerProject project, String newProjectName) {
        TimerProject newProject = project.clone();
        newProject.setName(newProjectName);
        for (VetoableDataEventListener vetoableDataEventListener : this.vetoableDataEventListeners) {
            vetoableDataEventListener.checkModifyProject(newProject);
        }
        project.setName(newProjectName);
        for (DataEventListener dataEventListener : this.dataEventListeners) {
            dataEventListener.modifyProject(project);
        }
    }

    public void editTask(TimerTask task, String newTaskName) {
        TimerTask newTask = task.clone();
        newTask.setName(newTaskName);
        for (VetoableDataEventListener vetoableDataEventListener : this.vetoableDataEventListeners) {
            vetoableDataEventListener.checkChangeClosedState(newTask);
        }
        task.setName(newTaskName);
        for (DataEventListener dataEventListener : this.dataEventListeners) {
            dataEventListener.modifyTask(task);
        }
    }

    public void moveTask(TimerTask destination, Collection<TimerTask> tasksToMove) {
        for (VetoableDataEventListener vetoableDataEventListener : this.vetoableDataEventListeners) {
            vetoableDataEventListener.checkMoveTask(destination, tasksToMove);
        }
        for (TimerTask taskToMove : tasksToMove) {
            Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
            while (itDataEventListener.hasNext()) {
                itDataEventListener.next().preMoveTask(taskToMove);
            }
            TimerTask actualParent = taskToMove.getParent();
            actualParent.getSubTasks().remove(taskToMove);
            destination.addTask(taskToMove);
            itDataEventListener = this.dataEventListeners.iterator();
            while (itDataEventListener.hasNext()) {
                itDataEventListener.next().moveTask(taskToMove);
            }
        }
    }

    public void mergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
        for (VetoableDataEventListener vetoableDataEventListener : this.vetoableDataEventListeners) {
            vetoableDataEventListener.checkMergeTasks(destinationTask, otherTasks);
        }
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().preMergeTasks(destinationTask, otherTasks);
        }
        for (TimerTask otherTask : otherTasks) {
            this.mergeTwoTasks(destinationTask, otherTask);
        }
        itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().postMergeTasks(destinationTask, otherTasks);
        }
    }

    protected void mergeTwoTasks(TimerTask destinationTask, TimerTask otherTask) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Merging two task : " + destinationTask.getName() + " and " + otherTask.getName()));
        }
        ArrayList<TimerTask> otherTaskSubTasks = new ArrayList<TimerTask>(otherTask.getSubTasks());
        for (TimerTask timerTask : otherTaskSubTasks) {
            TimerTask sameTaskNameTask = null;
            for (TimerTask destSubTask : destinationTask.getSubTasks()) {
                if (!destSubTask.getName().equals(timerTask.getName())) continue;
                sameTaskNameTask = destSubTask;
            }
            if (sameTaskNameTask == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Moving task " + timerTask.getName() + " to " + destinationTask.getName()));
                }
                this.moveTask(destinationTask, Collections.singleton(timerTask));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sub-merging of " + sameTaskNameTask.getName() + " and " + timerTask.getName()));
            }
            this.mergeTwoTasks(sameTaskNameTask, timerTask);
        }
        for (Map.Entry entry : otherTask.getAllDaysAndTimes().entrySet()) {
            Long currentDuration = destinationTask.getTime((Date)entry.getKey());
            currentDuration = currentDuration + (Long)entry.getValue();
            destinationTask.setTime((Date)entry.getKey(), currentDuration);
        }
        for (Map.Entry entry : otherTask.getAllDaysAnnotations().entrySet()) {
            Date noteKey = (Date)entry.getKey();
            while (destinationTask.getAllDaysAnnotations().containsKey(noteKey)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Annotation collision detected, try next second");
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(noteKey);
                calendar.add(13, 1);
                noteKey = calendar.getTime();
            }
            destinationTask.addAnnotation(noteKey, (String)entry.getValue());
        }
        for (TimerAlert timerAlert : otherTask.getAlerts()) {
            destinationTask.addAlert(timerAlert);
        }
        this.deleteTask(otherTask);
    }

    public void addAnnotation(TimerTask task, Date date, String annotation) {
        for (VetoableDataEventListener vetoableDataEventListener : this.vetoableDataEventListeners) {
            vetoableDataEventListener.checkSetAnnotation(task, date, annotation);
        }
        task.addAnnotation(date, annotation);
        for (DataEventListener dataEventListener : this.dataEventListeners) {
            dataEventListener.setAnnotation(task, date, annotation);
        }
    }

    public void modifyAlert(TimerTask task) {
        for (DataEventListener dataEventListener : this.dataEventListeners) {
            dataEventListener.modifyTask(task);
        }
    }
}

