/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimer;
import org.chorem.jtimer.io.Saver;
import org.chorem.jtimer.ws.ProjectManagement;

public class JTimerFactory {
    private static Log log = LogFactory.getLog(JTimerFactory.class);
    protected static ProjectManagement projectManagement;
    protected static Saver saver;

    protected JTimerFactory() {
    }

    public static ProjectManagement getProjectManagementService() {
        block9: {
            if (projectManagement == null) {
                Class implementationClass = JTimer.config.getServiceClass();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Using service class : " + implementationClass));
                    log.info((Object)(" with service endpoint : " + JTimer.config.getServiceEndpoint()));
                    log.info((Object)(" with service resource : " + JTimer.config.getServiceResource()));
                }
                if (implementationClass != null) {
                    try {
                        projectManagement = (ProjectManagement)implementationClass.newInstance();
                        projectManagement.setEndpoint(JTimer.config.getServiceEndpoint());
                        projectManagement.setResourceName(JTimer.config.getServiceResource());
                    }
                    catch (InstantiationException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Can't instanciate class : " + implementationClass), (Throwable)e);
                        }
                        break block9;
                    }
                    catch (IllegalAccessException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Can't access class : " + implementationClass), (Throwable)e);
                        }
                        break block9;
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"No sync information given, won't synchronize");
                }
            }
        }
        return projectManagement;
    }

    public static Saver getFileSaver() {
        block6: {
            if (saver == null) {
                Class saverClass = JTimer.config.getIOSaverClass();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Using saver class : " + saverClass));
                    log.info((Object)(" with saver home directory : " + JTimer.config.getIOSaverDirectory()));
                    log.info((Object)(" with auto save delay : " + JTimer.config.getIOSaverAutoSaveDelay()));
                }
                try {
                    saver = (Saver)saverClass.newInstance();
                    saver.setSaveDirectory(JTimer.config.getIOSaverDirectory());
                    saver.setAutoSaveDelay(JTimer.config.getIOSaverAutoSaveDelay() * 1000L);
                }
                catch (InstantiationException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Can't instanciate class : " + saverClass), (Throwable)e);
                    }
                }
                catch (IllegalAccessException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)("Can't access class : " + saverClass), (Throwable)e);
                }
            }
        }
        return saver;
    }
}

