/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ws.xmlrpc;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.chorem.jtimer.data.DataViolationException;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.entities.TimerTaskHelper;
import org.chorem.jtimer.ws.ConnectionDataHandler;
import org.chorem.jtimer.ws.ProjectManagement;
import org.chorem.jtimer.ws.exception.WebServiceException;
import org.chorem.jtimer.ws.xmlrpc.AbstractXMLRPCClient;
import org.chorem.jtimer.ws.xmlrpc.WSDaemon;

public class ChoremXMLRPCClient
extends AbstractXMLRPCClient
implements ProjectManagement {
    private static Log log = LogFactory.getLog(ChoremXMLRPCClient.class);
    protected String endpoint;
    protected String resourceName;
    protected Map<List<String>, String> taskToTopiaId;
    protected ConnectionDataHandler connectionDataHandler;
    protected TimerDataManager dataManager;

    @Override
    public void setDataManager(TimerDataManager dataManager) {
        this.dataManager = dataManager;
    }

    @Override
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public void setConnectionDataHandler(ConnectionDataHandler connectionDataHandler) {
        this.connectionDataHandler = connectionDataHandler;
    }

    @Override
    protected Object get(String serviceName, Object ... args) throws XmlRpcException {
        Object result = null;
        try {
            result = super.get(this.resourceName + "." + serviceName, args);
        }
        catch (XmlRpcException e) {
            if (e.getCause() instanceof ConnectException) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Can't connect through xmlrpc to " + this.endpoint), (Throwable)e);
                } else if (log.isErrorEnabled()) {
                    log.error((Object)("Can't connect through xmlrpc to " + this.endpoint));
                }
            }
            throw e;
        }
        return result;
    }

    @Override
    public Map<String, String> getIdAndLoginsMap() throws WebServiceException {
        String methodName = "getEmployees";
        Map idAndLogins = null;
        try {
            Object idAndLoginsObject = this.get("getEmployees", new Object[0]);
            if (idAndLoginsObject instanceof Map) {
                idAndLogins = (Map)idAndLoginsObject;
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception on xml-rpc service call (getEmployees)", (Throwable)e);
            }
            throw new WebServiceException("Can't call getEmployees!", e);
        }
        return idAndLogins;
    }

    @Override
    public String login(String login, String password) throws WebServiceException {
        String methodName = "login";
        String topiaId = null;
        try {
            Object topiaIdObject = this.get("login", login, password);
            if (topiaIdObject instanceof String) {
                topiaId = (String)topiaIdObject;
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception on xml-rpc service call (login)", (Throwable)e);
            }
            throw new WebServiceException("Can't call login!", e);
        }
        return topiaId;
    }

    @Override
    public List<TimerProject> getUserProjects(String userId) throws WebServiceException {
        String methodName = "getTasks";
        HashMap<String, TimerProject> result = new HashMap<String, TimerProject>();
        this.taskToTopiaId = new HashMap<List<String>, String>();
        try {
            Object oMapTopiaidTaskPath = this.get("getTasks", userId);
            if (oMapTopiaidTaskPath instanceof Map) {
                Map mapResult = (Map)oMapTopiaidTaskPath;
                for (String topiaId : mapResult.keySet()) {
                    Object[] oTaskNames = (Object[])mapResult.get(topiaId);
                    ArrayList<String> lTaskNames = new ArrayList<String>();
                    for (Object oTaskName : oTaskNames) {
                        String taskName = (String)oTaskName;
                        taskName = taskName.replaceAll("/", "-");
                        lTaskNames.add(taskName);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(" task found (" + topiaId + ") : " + lTaskNames));
                    }
                    this.addTask(result, lTaskNames);
                    this.taskToTopiaId.put(lTaskNames, topiaId);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Result found but not Map type : " + oMapTopiaidTaskPath));
            }
        }
        catch (XmlRpcException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception on xml-rpc service call (getTasks)", (Throwable)e);
            }
            throw new WebServiceException("Can't call getTasks!", e);
        }
        return new ArrayList<TimerProject>(result.values());
    }

    protected void addTask(Map<String, TimerProject> mapOfProjects, List<String> taskNames) {
        TimerProject project;
        String projectName = taskNames.get(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Manage project : " + projectName));
        }
        if ((project = mapOfProjects.get(projectName)) == null) {
            project = new TimerProject();
            project.setName("#" + projectName);
            project.setCreationDate(new Date());
            mapOfProjects.put(projectName, project);
        }
        this.addTask(project, taskNames.subList(1, taskNames.size()));
    }

    protected void addTask(TimerTask task, List<String> taskNames) {
        if (taskNames.size() > 0) {
            String taskName = taskNames.get(0);
            TimerTask currentTask = null;
            for (TimerTask subtask : task.getSubTasks()) {
                if (!subtask.getName().equals(taskName)) continue;
                currentTask = subtask;
            }
            if (currentTask == null) {
                currentTask = new TimerTask();
                currentTask.setName(taskName);
                currentTask.setCreationDate(new Date());
                task.addTask(currentTask);
            }
            this.addTask(currentTask, taskNames.subList(1, taskNames.size()));
        }
    }

    protected Date getLastUpdate(String userId) {
        Date result;
        block4: {
            String methodName = "getLastUpdate";
            result = null;
            try {
                Object tmpResult = this.get("getLastUpdate", userId);
                if (tmpResult instanceof Date) {
                    result = (Date)tmpResult;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getLastUpdate() = " + result));
                    }
                }
            }
            catch (XmlRpcException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Exception on xml-rpc service call (getLastUpdate)", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public void synchronize(String userId, List<TimerProject> projects) throws WebServiceException {
        Date lastUpdateDate = this.getLastUpdate(userId);
        if (lastUpdateDate == null) {
            lastUpdateDate = new Date(0L);
        }
        for (TimerProject project : projects) {
            if (!project.isSynchronized()) continue;
            String nonSynchonizedProjectName = project.getName().substring("#".length());
            ArrayList<String> pathNames = new ArrayList<String>(1);
            pathNames.add(nonSynchonizedProjectName);
            this.synchronizeTask(userId, project, lastUpdateDate, pathNames);
        }
    }

    protected void synchronizeTask(String userId, TimerTask task, Date lastUpdateDate, List<String> currentTaskPath) throws WebServiceException {
        String topiaId;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Manage task path : " + currentTaskPath));
        }
        Date firstDate = TimerTaskHelper.getTaskFirstDateOfTiming(task);
        Date lastDate = TimerTaskHelper.getTaskLastDateOfTiming(task);
        if (firstDate != null && lastDate != null) {
            Calendar toDay;
            Calendar firstCalendar = Calendar.getInstance();
            firstCalendar.setTime(firstDate);
            Calendar lastCalendar = Calendar.getInstance();
            firstCalendar.setTime(lastDate);
            Calendar lastUpdateCalendar = Calendar.getInstance();
            lastUpdateCalendar.setTimeInMillis(lastUpdateDate.getTime());
            lastUpdateCalendar.add(6, 1);
            Calendar yesterdayCalendar = Calendar.getInstance();
            yesterdayCalendar.add(6, -1);
            Calendar fromDay = firstCalendar.compareTo(lastUpdateCalendar) < 0 ? lastUpdateCalendar : firstCalendar;
            Calendar calendar = toDay = lastCalendar.compareTo(yesterdayCalendar) < 0 ? lastCalendar : yesterdayCalendar;
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Sync task time : " + task.getName()));
                log.debug((Object)("  from " + fromDay.get(5) + "/" + (fromDay.get(2) + 1) + "/" + fromDay.get(1)));
                log.debug((Object)("  to " + toDay.get(5) + "/" + (toDay.get(2) + 1) + "/" + toDay.get(1)));
            }
            while (fromDay.compareTo(toDay) <= 0) {
                long timeOfCurrentDay = task.getTime(fromDay.getTime());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("time of day " + fromDay.get(5) + "/" + (fromDay.get(2) + 1) + "/" + fromDay.get(1) + " = " + timeOfCurrentDay + " (calendar = " + fromDay + ")"));
                }
                if (timeOfCurrentDay > 0L) {
                    String topiaId2 = this.taskToTopiaId.get(currentTaskPath);
                    if (topiaId2 == null) {
                        String superTopiaId = this.taskToTopiaId.get(currentTaskPath.subList(0, currentTaskPath.size() - 1));
                        topiaId2 = this.addTask(userId, superTopiaId, task.getName());
                        if (topiaId2 != null) {
                            this.taskToTopiaId.put(currentTaskPath, topiaId2);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Add task : " + currentTaskPath + " topiaId = " + topiaId2));
                        }
                    }
                    if (topiaId2 != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(" sending time for  " + topiaId2 + " = " + timeOfCurrentDay));
                        }
                        this.syncTask(userId, topiaId2, fromDay.getTime(), timeOfCurrentDay * 1000L);
                    } else if (log.isFatalEnabled()) {
                        log.fatal((Object)("Can't get topiaId for task : " + task.getName()));
                        log.fatal((Object)"Chorem error ?");
                    }
                }
                fromDay.add(6, 1);
            }
        } else if (task.getSubTasks() != null && !task.getSubTasks().isEmpty() && (topiaId = this.taskToTopiaId.get(currentTaskPath)) == null) {
            String superTopiaId = this.taskToTopiaId.get(currentTaskPath.subList(0, currentTaskPath.size() - 1));
            topiaId = this.addTask(userId, superTopiaId, task.getName());
            if (topiaId != null) {
                this.taskToTopiaId.put(currentTaskPath, topiaId);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add task : " + currentTaskPath + " topiaId = " + topiaId));
            }
        }
        for (TimerTask subTask : task.getSubTasks()) {
            ArrayList<String> childTaskPath = new ArrayList<String>(currentTaskPath);
            childTaskPath.add(subTask.getName());
            this.synchronizeTask(userId, subTask, lastUpdateDate, childTaskPath);
        }
    }

    protected String addTask(String userId, String superTopiaId, String name) {
        String topiaId;
        block4: {
            String methodName = "addTask";
            topiaId = null;
            try {
                Object oTopiaId = this.get("addTask", userId, superTopiaId, name);
                if (oTopiaId instanceof String) {
                    topiaId = (String)oTopiaId;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("addTask() = " + topiaId));
                    }
                }
            }
            catch (XmlRpcException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Exception on xml-rpc service call (addTask)", (Throwable)e);
            }
        }
        return topiaId;
    }

    protected void syncTask(String userId, String topiaId, Date dateOfDay, long timeOfDay) throws WebServiceException {
        String methodName = "syncTask";
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("syncTask(" + userId + ", " + topiaId + ", " + dateOfDay + ", " + timeOfDay + ")"));
            }
            this.get("syncTask", userId, topiaId, dateOfDay, (int)timeOfDay);
        }
        catch (XmlRpcException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception on xml-rpc service call (syncTask)", (Throwable)e);
            }
            throw new WebServiceException("Can't call syncTask!", e);
        }
    }

    @Override
    public void syncTask(String userId, TimerTask task, Date dateOfDay, long timeOfDay) throws WebServiceException {
        if (task != null && TimerTaskHelper.getTaskProject(task).isSynchronized()) {
            List<String> taskPath;
            String topiaId;
            if (this.taskToTopiaId == null) {
                this.getUserProjects(userId);
            }
            if ((topiaId = this.taskToTopiaId.get(taskPath = TimerTaskHelper.getTaskPath(task))) != null) {
                this.syncTask(userId, topiaId, dateOfDay, timeOfDay);
            } else {
                for (int toIndex = 1; toIndex < taskPath.size(); ++toIndex) {
                    String superTopiaId = this.taskToTopiaId.get(taskPath.subList(0, toIndex));
                    if (superTopiaId == null || (topiaId = this.taskToTopiaId.get(taskPath.subList(0, toIndex + 1))) != null) continue;
                    topiaId = this.addTask(userId, superTopiaId, taskPath.get(toIndex));
                    if (topiaId != null) {
                        this.taskToTopiaId.put(taskPath.subList(0, toIndex + 1), topiaId);
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"Add new task failed on chorem");
                }
                topiaId = this.taskToTopiaId.get(taskPath);
                if (topiaId != null) {
                    this.syncTask(userId, topiaId, dateOfDay, timeOfDay);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"Try to add time on an unknown synchronized task");
                }
            }
        }
    }

    protected void synchronization() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Synchronization");
        }
        WSDaemon webServicesDeamon = new WSDaemon(this, this.dataManager);
        webServicesDeamon.setConnectionDataHandler(this.connectionDataHandler);
        Timer timer = new Timer();
        Calendar date = Calendar.getInstance();
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        timer.schedule((java.util.TimerTask)webServicesDeamon, date.getTime(), 86400000L);
    }

    @Override
    public void addProject(TimerProject project) {
    }

    @Override
    public void addTask(TimerTask task) {
    }

    @Override
    public void dataLoaded(Collection<TimerProject> projects) {
        this.synchronization();
    }

    @Override
    public void preDeleteProject(TimerProject project) {
    }

    @Override
    public void preDeleteTask(TimerTask task) {
    }

    @Override
    public void deleteProject(TimerProject project) {
    }

    @Override
    public void deleteTask(TimerTask task) {
    }

    @Override
    public void modifyProject(TimerProject project) {
    }

    @Override
    public void modifyTask(TimerTask task) {
    }

    @Override
    public void preChangeClosedState(TimerTask task) {
    }

    @Override
    public void postChangeClosedState(TimerTask task) {
    }

    @Override
    public void moveTask(TimerTask task) {
    }

    @Override
    public void postMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }

    @Override
    public void preMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }

    @Override
    public void preMoveTask(TimerTask task) {
    }

    @Override
    public void startTask(TimerTask task) {
    }

    @Override
    public void stopTask(TimerTask task) {
    }

    @Override
    public void checkSetAnnotation(TimerTask task, Date date, String annotation) {
    }

    @Override
    public void setAnnotation(TimerTask task, Date date, String annotation) {
    }

    @Override
    public void checkSetTaskTime(TimerTask task, Date date, Long value) {
    }

    @Override
    public void setTaskTime(TimerTask task, Date date, Long time) {
        if (task != null && TimerTaskHelper.getTaskProject(task).isSynchronized()) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (calendar.getTime().before(date)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Today modification, can't synchronize");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sync task " + task.getName()));
                    log.debug((Object)(" date = " + date));
                    log.debug((Object)(" value =" + time));
                }
                try {
                    String login = this.connectionDataHandler.getConnectionInformation(this).getLogin();
                    if (login != null) {
                        this.syncTask(login, task, date, time * 1000L);
                    }
                }
                catch (WebServiceException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void checkAddProject(TimerProject project) {
    }

    @Override
    public void checkAddTask(TimerTask parent, TimerTask task) {
    }

    @Override
    public void checkChangeClosedState(TimerTask task) {
    }

    @Override
    public void checkDeleteProject(TimerProject project) {
    }

    @Override
    public void checkDeleteTask(TimerTask task) {
        TimerProject project = TimerTaskHelper.getTaskProject(task);
        if (project.isSynchronized()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Project is synchronized, checkDeleteTask won't pass");
            }
            throw new DataViolationException("Can't delete task projet", "vetoable.ws.chorem.cant.modify.synchronized.project");
        }
    }

    @Override
    public void checkModifyProject(TimerProject project) {
        if (project.isSynchronized()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Project is synchronized, checkModifyProject won't pass");
            }
            throw new DataViolationException("Can't modify projet", "vetoable.ws.chorem.cant.modify.synchronized.project");
        }
    }

    @Override
    public void checkModifyTask(TimerTask task) {
        TimerProject project = TimerTaskHelper.getTaskProject(task);
        if (project.isSynchronized()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Project is synchronized, checkModifyTask won't pass");
            }
            throw new DataViolationException("Can't modify task", "vetoable.ws.chorem.cant.modify.synchronized.project");
        }
    }

    @Override
    public void checkMoveTask(TimerTask destination, Collection<TimerTask> tasksToMove) {
        boolean syncProject = false;
        TimerProject project1 = TimerTaskHelper.getTaskProject(destination);
        if (project1.isSynchronized()) {
            syncProject = true;
        }
        for (TimerTask taskToMove : tasksToMove) {
            TimerProject project2 = TimerTaskHelper.getTaskProject(taskToMove);
            if (!project2.isSynchronized()) continue;
            syncProject = true;
        }
        if (syncProject) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Project is synchronized, checkMoveTask won't pass");
            }
            throw new DataViolationException("Can't modify task", "vetoable.ws.chorem.cant.modify.synchronized.project");
        }
    }

    @Override
    public void checkMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
        TimerProject project1 = TimerTaskHelper.getTaskProject(destinationTask);
        if (project1.isSynchronized()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Project is synchronized, checkMergeTask won't pass");
            }
            throw new DataViolationException("Can't modify task", "vetoable.ws.chorem.cant.modify.synchronized.project");
        }
        for (TimerTask otherTask : otherTasks) {
            TimerProject otherProject = TimerTaskHelper.getTaskProject(otherTask);
            if (!otherProject.isSynchronized()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Project is synchronized, checkMergeTask won't pass");
            }
            throw new DataViolationException("Can't modify task", "vetoable.ws.chorem.cant.modify.synchronized.project");
        }
    }
}

