/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.widget;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JPopupTrayIcon
extends TrayIcon
implements MouseListener,
PopupMenuListener {
    private JPopupMenu menu;
    private Window window;
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("windows");

    public JPopupTrayIcon(Image image, String tooltip, JPopupMenu popup) {
        super(image, tooltip);
        this.addMouseListener(this);
        this.setJPopupMenu(popup);
    }

    protected void showJPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger() && this.menu != null && this.window == null) {
            if (IS_WINDOWS) {
                this.window = new JDialog((Frame)null);
                ((JDialog)this.window).setUndecorated(true);
            } else {
                this.window = new JWindow((Frame)null);
            }
            this.window.setAlwaysOnTop(true);
            Dimension size = this.menu.getPreferredSize();
            Point centerPoint = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            if ((double)e.getY() > centerPoint.getY()) {
                this.window.setLocation(e.getX(), e.getY() - size.height);
            } else {
                this.window.setLocation(e.getX(), e.getY());
            }
            this.window.setVisible(true);
            this.menu.show(((RootPaneContainer)((Object)this.window)).getContentPane(), 0, 0);
            this.window.toFront();
        }
    }

    public JPopupMenu getJPopupMenu() {
        return this.menu;
    }

    public void setJPopupMenu(JPopupMenu menu) {
        if (this.menu != null) {
            this.menu.removePopupMenuListener(this);
        }
        this.menu = menu;
        menu.addPopupMenuListener(this);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.window != null) {
            this.window.dispose();
            this.window = null;
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        if (this.window != null) {
            this.window.dispose();
            this.window = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showJPopupMenu(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.showJPopupMenu(e);
    }
}

