/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.treetable.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.DataViolationException;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.entities.TimerTaskHelper;
import org.chorem.jtimer.ui.treetable.ProjectsAndTasksTable;
import org.chorem.jtimer.ui.treetable.dnd.TimerTaskTranferable;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;

public class TimerTaskTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 5433321973795969278L;
    private static Log log = LogFactory.getLog(TimerTaskTransferHandler.class);
    protected ResourceMap resourceMap;
    protected TimerDataManager dataManager;

    public TimerTaskTransferHandler(Application application, TimerDataManager dataManager) {
        this.dataManager = dataManager;
        ApplicationContext ctxt = application.getContext();
        ResourceManager mgr = ctxt.getResourceManager();
        this.resourceMap = mgr.getResourceMap(TimerTaskTransferHandler.class);
    }

    @Override
    public boolean canImport(JComponent cp, DataFlavor[] df) {
        for (int i = 0; i < df.length; ++i) {
            if (!df[i].equals(TimerTaskTranferable.myData)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent component, Transferable transferable) {
        boolean confirmImport;
        block8: {
            confirmImport = false;
            if (transferable.isDataFlavorSupported(TimerTaskTranferable.myData)) {
                try {
                    ProjectsAndTasksTable treeTable = (ProjectsAndTasksTable)((Object)component);
                    List<TimerTask> selectedTasks = treeTable.getSelectedElements();
                    if (selectedTasks != null && !selectedTasks.isEmpty()) {
                        boolean validMove;
                        TimerTask destinationTask = selectedTasks.get(0);
                        Object myObject = transferable.getTransferData(TimerTaskTranferable.myData);
                        List movedTasks = (List)myObject;
                        boolean bl = validMove = !TimerTaskHelper.collectionContainsTask(movedTasks, destinationTask);
                        if (validMove) {
                            String title = this.resourceMap.getString("move.task.title", new Object[0]);
                            String message = movedTasks.size() == 1 ? this.resourceMap.getString("move.task.message", new Object[]{((TimerTask)movedTasks.get(0)).getName(), destinationTask.getName()}) : this.resourceMap.getString("move.tasks.message", new Object[]{movedTasks.size(), destinationTask.getName()});
                            int answer = JOptionPane.showConfirmDialog(component, message, title, 0, 3);
                            if (answer == 0) {
                                confirmImport = true;
                            }
                        }
                    }
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Exception while transfering task", (Throwable)e);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error((Object)"Exception while transfering task", (Throwable)e);
                }
            }
        }
        return confirmImport;
    }

    @Override
    protected Transferable createTransferable(JComponent cp) {
        TimerTaskTranferable transferable = null;
        ProjectsAndTasksTable treeTable = (ProjectsAndTasksTable)((Object)cp);
        List<TimerTask> selectedTasks = treeTable.getSelectedTasks();
        if (selectedTasks != null && !selectedTasks.isEmpty()) {
            LinkedList<TimerTask> tasks = new LinkedList<TimerTask>(selectedTasks);
            transferable = new TimerTaskTranferable(tasks);
        }
        return transferable;
    }

    @Override
    protected void exportDone(JComponent cp, Transferable transferable, int type) {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Transfert done");
            }
            if (type == 2) {
                try {
                    ProjectsAndTasksTable treeTable = (ProjectsAndTasksTable)((Object)cp);
                    List<TimerTask> selectedTasks = treeTable.getSelectedElements();
                    if (selectedTasks != null && !selectedTasks.isEmpty()) {
                        TimerTask destinationTask = selectedTasks.get(0);
                        Object myObject = transferable.getTransferData(TimerTaskTranferable.myData);
                        List movedTasks = (List)myObject;
                        try {
                            this.dataManager.moveTask(destinationTask, movedTasks);
                        }
                        catch (DataViolationException e) {
                            String title = this.resourceMap.getString("action.invalidActionTitle", new Object[0]);
                            String message = this.resourceMap.getString(e.getExceptionKey(), new Object[0]);
                            if (StringUtils.isEmpty((String)message)) {
                                message = this.resourceMap.getString("action.missingErrorMessage", new Object[]{e.getExceptionKey()});
                            }
                            JOptionPane.showMessageDialog(cp, message, title, 0);
                        }
                    }
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Exception while transfering task", (Throwable)e);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    if (!log.isErrorEnabled()) break block10;
                    log.error((Object)"Exception while transfering task", (Throwable)e);
                }
            }
        }
    }

    @Override
    public int getSourceActions(JComponent component) {
        return 2;
    }
}

