/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.treetable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.DataEventListener;
import org.chorem.jtimer.data.TimerCore;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.entities.TimerTaskHelper;
import org.chorem.jtimer.ui.treetable.ProjectsAndTasksTable;
import org.jdesktop.swingx.tree.TreeModelSupport;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

public class ProjectsAndTasksModel
extends AbstractTreeTableModel
implements DataEventListener {
    private static Log log = LogFactory.getLog(ProjectsAndTasksModel.class);
    public static final int OPERATION_ADD = 0;
    public static final int OPERATION_MODIFY = 1;
    public static final int OPERATION_DELETE = 2;
    protected ProjectsAndTasksTable projectsAndTaskTable;
    protected TimerDataManager dataManager;
    protected List<String> columnIdentifiers;
    protected boolean showClosedTask = false;

    public ProjectsAndTasksModel(ProjectsAndTasksTable projectsAndTaskTable, TimerCore core, List<String> columnIdentifiers) {
        super((Object)new TimerProject("root"));
        this.projectsAndTaskTable = projectsAndTaskTable;
        this.dataManager = core.getData();
        this.columnIdentifiers = columnIdentifiers;
    }

    protected TreeModelSupport getModelSupport() {
        return this.modelSupport;
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int column) {
        return this.columnIdentifiers.get(column);
    }

    public Object getValueAt(Object object, int column) {
        String value = "n/a";
        if (object instanceof TimerTask) {
            TimerTask task = (TimerTask)object;
            switch (column) {
                case 0: {
                    value = task.getName();
                    break;
                }
                case 1: {
                    value = DurationFormatUtils.formatDuration((long)(TimerTaskHelper.getTotalTime(task, new Date()) * 1000L), (String)"HH:mm:ss");
                    break;
                }
                case 2: {
                    value = DurationFormatUtils.formatDuration((long)(TimerTaskHelper.getAllTotalTime(task) * 1000L), (String)"HH:mm:ss");
                }
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("bad user object " + object));
        }
        return value;
    }

    public boolean isCellEditable(Object object, int column) {
        return false;
    }

    public Object getChild(Object parent, int index) {
        TimerTask t = this.getFiteredSubListFor(parent).get(index);
        return t;
    }

    public int getChildCount(Object parent) {
        int childCount = this.getFiteredSubListFor(parent).size();
        return childCount;
    }

    protected List<TimerTask> getFiteredSubListFor(Object parent) {
        ArrayList<TimerTask> result = new ArrayList<TimerTask>();
        if (parent == this.root) {
            result.addAll(this.dataManager.getProjectsList());
        } else {
            TimerTask task = (TimerTask)parent;
            result.addAll(TimerTaskHelper.getSubTasksOrderedByName(task));
        }
        if (!this.showClosedTask) {
            CollectionUtils.filter(result, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    boolean result = false;
                    if (object instanceof TimerTask) {
                        TimerTask task = (TimerTask)object;
                        result = !task.isClosed();
                    }
                    return result;
                }
            });
        }
        return result;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int childIndex = this.getFiteredSubListFor(parent).indexOf(child);
        return childIndex;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    protected void notifyTaskChanged(TimerTask task, int operation) {
        TreePath path = new TreePath(this.root);
        this.updateChildren(task, path, operation);
    }

    protected boolean updateChildren(TimerTask task, TreePath path, int operation) {
        TimerTask pathLastComponent = (TimerTask)path.getLastPathComponent();
        boolean updated = false;
        int childCount = this.getChildCount(pathLastComponent);
        for (int childIndex = 0; !updated && childIndex < childCount; ++childIndex) {
            TimerTask taskUO = (TimerTask)this.getChild(pathLastComponent, childIndex);
            TreePath childTreePath = path.pathByAddingChild(taskUO);
            if (task.equals(taskUO)) {
                switch (operation) {
                    case 0: {
                        this.getModelSupport().fireChildAdded(path, childIndex, (Object)taskUO);
                        this.projectsAndTaskTable.expandPath(path);
                        break;
                    }
                    case 2: {
                        this.getModelSupport().fireChildRemoved(path, childIndex, (Object)taskUO);
                        break;
                    }
                    case 1: {
                        this.getModelSupport().fireChildChanged(path, childIndex, (Object)taskUO);
                        break;
                    }
                    default: {
                        if (!log.isErrorEnabled()) break;
                        log.error((Object)("Unknow operation : " + operation));
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)(" updated : " + childTreePath));
                }
                updated = true;
                continue;
            }
            updated = this.updateChildren(task, childTreePath, operation);
            if (!updated) continue;
            this.getModelSupport().firePathChanged(path);
        }
        return updated;
    }

    @Override
    public void addProject(TimerProject project) {
        this.notifyTaskChanged(project, 0);
    }

    @Override
    public void addTask(TimerTask task) {
        this.notifyTaskChanged(task, 0);
    }

    @Override
    public void dataLoaded(Collection<TimerProject> projects) {
        final ArrayList<TableColumn> tcs = new ArrayList<TableColumn>();
        for (TableColumn tc : this.projectsAndTaskTable.getColumns()) {
            tcs.add(tc);
        }
        this.getModelSupport().fireNewRoot();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (TableColumn tc : tcs) {
                    ProjectsAndTasksModel.this.projectsAndTaskTable.getColumnExt(tc.getIdentifier()).setPreferredWidth(tc.getPreferredWidth());
                }
            }
        });
    }

    @Override
    public void preDeleteProject(TimerProject project) {
        this.notifyTaskChanged(project, 2);
    }

    @Override
    public void preDeleteTask(TimerTask task) {
        this.notifyTaskChanged(task, 2);
    }

    @Override
    public void deleteProject(TimerProject project) {
    }

    @Override
    public void deleteTask(TimerTask task) {
    }

    @Override
    public void modifyProject(TimerProject project) {
        this.notifyTaskChanged(project, 1);
    }

    @Override
    public void modifyTask(TimerTask task) {
        this.notifyTaskChanged(task, 1);
    }

    @Override
    public void setAnnotation(TimerTask task, Date date, String annotation) {
    }

    @Override
    public void setTaskTime(TimerTask task, Date date, Long time) {
        this.notifyTaskChanged(task, 1);
    }

    @Override
    public void postChangeClosedState(TimerTask task) {
    }

    @Override
    public void preChangeClosedState(TimerTask task) {
        if (this.showClosedTask) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Fire modify on state change because hidden task are shown");
            }
            this.notifyTaskChanged(task, 1);
        } else if (!task.isClosed()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Fire delete on state change because task disapear from view");
            }
            this.notifyTaskChanged(task, 2);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Fire add on state change because task reappear in view");
            }
            this.notifyTaskChanged(task, 0);
        }
    }

    @Override
    public void startTask(TimerTask task) {
    }

    @Override
    public void stopTask(TimerTask task) {
    }

    public void setShowClosed(boolean showClosedTask) {
        this.showClosedTask = showClosedTask;
        this.getModelSupport().fireNewRoot();
    }

    @Override
    public void moveTask(TimerTask task) {
        this.notifyTaskChanged(task, 0);
    }

    @Override
    public void preMoveTask(TimerTask task) {
        this.notifyTaskChanged(task, 2);
    }

    @Override
    public void postMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
        this.notifyTaskChanged(destinationTask, 1);
        for (TimerTask otherTask : otherTasks) {
            this.notifyTaskChanged(otherTask, 2);
        }
    }

    @Override
    public void preMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }
}

