/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.tasks;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimer;
import org.chorem.jtimer.JTimerFactory;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.TimerAlert;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.entities.TimerTaskHelper;
import org.chorem.jtimer.ui.system.SystemInfo;
import org.chorem.jtimer.ui.system.SystemInfoFactory;
import org.chorem.jtimer.ui.system.UnsupportedSystemInfoException;
import org.chorem.jtimer.ui.tasks.IdleDialog;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;

public class RunTaskJob
extends Task<Void, Long> {
    private static Log log = LogFactory.getLog(RunTaskJob.class);
    protected JTimer parentApp;
    protected TimerTask managedTask;
    protected TimerDataManager dataManager;
    protected SystemInfo systemInfo;
    protected long taskTimingBeforeStartInMs;
    protected Calendar taskStartCalendar;
    protected Collection<TimerAlert> alreadyTrownAlerts;
    protected long offsetTimeInMs;
    protected long lastPublishTimestamp;
    protected Boolean bWantToStop;

    public RunTaskJob(JTimer parentApp, TimerTask managedTask, TimerDataManager dataManager) {
        super((Application)parentApp);
        this.parentApp = parentApp;
        this.bWantToStop = Boolean.FALSE;
        this.managedTask = managedTask;
        this.dataManager = dataManager;
        this.alreadyTrownAlerts = new HashSet<TimerAlert>();
        this.checkAlreadyThrownAlerts(managedTask);
        try {
            this.systemInfo = SystemInfoFactory.getSystemInfo();
        }
        catch (UnsupportedSystemInfoException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get system info", (Throwable)e);
            }
            this.systemInfo = null;
        }
    }

    protected void checkAlreadyThrownAlerts(TimerTask task) {
        Date now = new Date();
        for (TimerAlert alert : task.getAlerts()) {
            if (alert.getType().equals((Object)TimerAlert.Type.REACH_DAILY_TIME) && TimerTaskHelper.getTotalTime(task, now) > alert.getDuration()) {
                this.alreadyTrownAlerts.add(alert.clone());
                continue;
            }
            if (!alert.getType().equals((Object)TimerAlert.Type.REACH_TOTAL_TIME) || TimerTaskHelper.getAllTotalTime(task) <= alert.getDuration()) continue;
            this.alreadyTrownAlerts.add(alert.clone());
        }
        if (task.getParent() != null) {
            this.checkAlreadyThrownAlerts(task.getParent());
        }
    }

    public TimerTask getTask() {
        return this.managedTask;
    }

    public void incrementTaskTime(long increment) {
        long nowTimestamp = Calendar.getInstance().getTimeInMillis();
        long localIncrement = increment;
        if (this.taskTimingBeforeStartInMs + nowTimestamp - this.taskStartCalendar.getTimeInMillis() + this.offsetTimeInMs + increment < 0L) {
            localIncrement = -(this.taskTimingBeforeStartInMs + nowTimestamp - this.taskStartCalendar.getTimeInMillis() + this.offsetTimeInMs);
        }
        this.offsetTimeInMs += localIncrement;
    }

    public void resetTiming() {
        this.taskStartCalendar = Calendar.getInstance();
        this.lastPublishTimestamp = this.taskStartCalendar.getTimeInMillis();
        this.taskTimingBeforeStartInMs = this.managedTask.getTime(new Date()) * 1000L;
        this.offsetTimeInMs = 0L;
    }

    protected void checkReset() {
        Calendar nowCalendar = Calendar.getInstance();
        if (nowCalendar.get(6) != this.taskStartCalendar.get(6)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Day change detected, reset timing");
            }
            this.resetTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground() throws Exception {
        this.parentApp.startedTask(this.managedTask);
        this.resetTiming();
        long configIdleTime = JTimerFactory.getIdleTime();
        boolean dontWantToStop = true;
        while (dontWantToStop) {
            long loopTimestamp = Calendar.getInstance().getTimeInMillis();
            if (loopTimestamp - this.lastPublishTimestamp >= configIdleTime) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Hibernate detected, reseting timing");
                }
                this.resetTiming();
            }
            this.lastPublishTimestamp = loopTimestamp;
            long idleTime = 0L;
            if (this.systemInfo != null) {
                idleTime = this.systemInfo.getIdleTime();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User is idle since " + idleTime / 1000L + " s"));
                }
            }
            this.checkReset();
            if (idleTime >= JTimerFactory.getIdleTime()) {
                long currentTime;
                this.offsetTimeInMs -= configIdleTime;
                this.publish(new Long[]{this.taskTimingBeforeStartInMs + loopTimestamp - this.taskStartCalendar.getTimeInMillis() + this.offsetTimeInMs});
                JTimer parentApplication = (JTimer)this.getApplication();
                parentApplication.preIdleDetect();
                int option = IdleDialog.showIdleDialog(loopTimestamp - idleTime);
                parentApplication.postIdleDetect();
                this.lastPublishTimestamp = currentTime = Calendar.getInstance().getTimeInMillis();
                switch (option) {
                    case 0: {
                        ((JTimer)this.getApplication()).stopTask(this.managedTask);
                        break;
                    }
                    case 1: {
                        this.offsetTimeInMs += configIdleTime;
                        this.publish(new Long[]{this.taskTimingBeforeStartInMs + currentTime - this.taskStartCalendar.getTimeInMillis() + this.offsetTimeInMs});
                        break;
                    }
                    default: {
                        this.offsetTimeInMs -= currentTime - loopTimestamp;
                        this.publish(new Long[]{this.taskTimingBeforeStartInMs + currentTime - this.taskStartCalendar.getTimeInMillis() + this.offsetTimeInMs});
                        break;
                    }
                }
            } else {
                this.publish(new Long[]{this.taskTimingBeforeStartInMs + loopTimestamp - this.taskStartCalendar.getTimeInMillis() + this.offsetTimeInMs});
            }
            Thread.sleep(1000L);
            Boolean bl = this.bWantToStop;
            synchronized (bl) {
                dontWantToStop = this.bWantToStop == false;
            }
        }
        return null;
    }

    protected void process(List<Long> durations) {
        long currentDuration = durations.get(durations.size() - 1);
        this.dataManager.changeTaskTime(this.managedTask, new Date(), currentDuration / 1000L);
        this.checkTaskAlerts(this.managedTask);
    }

    protected void checkTaskAlerts(TimerTask task) {
        Date now = new Date();
        for (TimerAlert alert : task.getAlerts()) {
            if (this.alreadyTrownAlerts.contains(alert)) continue;
            if (alert.getType().equals((Object)TimerAlert.Type.REACH_DAILY_TIME) && TimerTaskHelper.getTotalTime(task, now) >= alert.getDuration()) {
                this.displayAlert(task, TimerAlert.Type.REACH_DAILY_TIME, alert.getDuration());
                this.alreadyTrownAlerts.add(alert.clone());
                continue;
            }
            if (!alert.getType().equals((Object)TimerAlert.Type.REACH_TOTAL_TIME) || TimerTaskHelper.getAllTotalTime(task) < alert.getDuration()) continue;
            this.displayAlert(task, TimerAlert.Type.REACH_TOTAL_TIME, alert.getDuration());
            this.alreadyTrownAlerts.add(alert.clone());
        }
        if (task.getParent() != null) {
            this.checkTaskAlerts(task.getParent());
        }
    }

    protected void displayAlert(final TimerTask task, final TimerAlert.Type alertType, final long alertDuration) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String alertMessage = null;
                String formattedTime = DurationFormatUtils.formatDuration((long)(alertDuration * 1000L), (String)"HH:mm:ss");
                if (TimerAlert.Type.REACH_DAILY_TIME.equals((Object)alertType)) {
                    alertMessage = RunTaskJob.this.getResourceMap().getString("alert.dailyAlertMessage", new Object[]{task.getName(), formattedTime});
                } else if (TimerAlert.Type.REACH_TOTAL_TIME.equals((Object)alertType)) {
                    alertMessage = RunTaskJob.this.getResourceMap().getString("alert.totalAlertMessage", new Object[]{task.getName(), formattedTime});
                }
                JOptionPane.showMessageDialog(null, alertMessage, RunTaskJob.this.getResourceMap().getString("alert.title", new Object[0]), 1, RunTaskJob.this.getResourceMap().getIcon("alert.alertIcon"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantToStop() {
        Boolean bl = this.bWantToStop;
        synchronized (bl) {
            this.bWantToStop = Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopping() {
        boolean stopping;
        Boolean bl = this.bWantToStop;
        synchronized (bl) {
            stopping = this.bWantToStop;
        }
        return stopping;
    }
}

