/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.entities.TimerTaskHelper;

public class ReportUtils {
    public List<Date> getDailyDates(Date begin, Date end) {
        List<Date> days = this.getPeriodDates(begin, end, 6);
        return days;
    }

    public List<Date> getWeeklyDates(Date begin, Date end) {
        List<Date> weeks = this.getPeriodDates(begin, end, 3);
        return weeks;
    }

    public List<Date> getMonthlyDates(Date begin, Date end) {
        List<Date> months = this.getPeriodDates(begin, end, 2);
        return months;
    }

    public List<Date> getYearlyDates(Date begin, Date end) {
        List<Date> years = this.getPeriodDates(begin, end, 1);
        return years;
    }

    protected List<Date> getPeriodDates(Date begin, Date end, int calendarField) {
        ArrayList<Date> periods = new ArrayList<Date>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(begin);
        while (cal.getTime().compareTo(end) <= 0) {
            periods.add(cal.getTime());
            cal.add(calendarField, 1);
        }
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(end);
        if (cal.get(calendarField) == calEnd.get(calendarField)) {
            periods.add(end);
        }
        return periods;
    }

    public long getDailyTaskTime(TimerTask task, Date day) {
        long result = 0L;
        result = task.getTime(day);
        return result;
    }

    public long getWeeklyTaskTime(TimerTask task, Date week, Date fromDay, Date toDay) {
        long result = 0L;
        Calendar beginPeriodDate = Calendar.getInstance();
        beginPeriodDate.setTime(week);
        beginPeriodDate.set(7, beginPeriodDate.getFirstDayOfWeek());
        Calendar endPeriodDate = (Calendar)beginPeriodDate.clone();
        endPeriodDate.add(3, 1);
        endPeriodDate.add(6, -1);
        Calendar loopPeriodDate = beginPeriodDate;
        while (loopPeriodDate.compareTo(endPeriodDate) <= 0) {
            if (!(fromDay != null && fromDay.compareTo(loopPeriodDate.getTime()) > 0 || toDay != null && toDay.compareTo(loopPeriodDate.getTime()) < 0)) {
                result += task.getTime(loopPeriodDate.getTime());
            }
            loopPeriodDate.add(6, 1);
        }
        return result;
    }

    public long getMonthlyTaskTime(TimerTask task, Date month, Date fromDay, Date toDay) {
        long result = 0L;
        Calendar beginPeriodDate = Calendar.getInstance();
        beginPeriodDate.setTime(month);
        beginPeriodDate.set(5, 1);
        Calendar endPeriodDate = (Calendar)beginPeriodDate.clone();
        endPeriodDate.add(2, 1);
        endPeriodDate.add(6, -1);
        Calendar loopPeriodDate = beginPeriodDate;
        while (loopPeriodDate.compareTo(endPeriodDate) <= 0) {
            if (!(fromDay != null && fromDay.compareTo(loopPeriodDate.getTime()) > 0 || toDay != null && toDay.compareTo(loopPeriodDate.getTime()) < 0)) {
                result += task.getTime(loopPeriodDate.getTime());
            }
            loopPeriodDate.add(6, 1);
        }
        return result;
    }

    public long getYearlyTaskTime(TimerTask task, Date year, Date fromDay, Date toDay) {
        long result = 0L;
        Calendar beginPeriodDate = Calendar.getInstance();
        beginPeriodDate.setTime(year);
        beginPeriodDate.set(5, 1);
        beginPeriodDate.set(2, 0);
        Calendar endPeriodDate = (Calendar)beginPeriodDate.clone();
        endPeriodDate.add(1, 1);
        endPeriodDate.add(6, -1);
        Calendar loopPeriodDate = beginPeriodDate;
        while (loopPeriodDate.compareTo(endPeriodDate) <= 0) {
            if (!(fromDay != null && fromDay.compareTo(loopPeriodDate.getTime()) > 0 || toDay != null && toDay.compareTo(loopPeriodDate.getTime()) < 0)) {
                result += task.getTime(loopPeriodDate.getTime());
            }
            loopPeriodDate.add(6, 1);
        }
        return result;
    }

    public long getDailyTotalTaskTime(TimerTask task, Date day) {
        long result = 0L;
        result = TimerTaskHelper.getTotalTime(task, day);
        return result;
    }

    public long getWeeklyTotalTaskTime(TimerTask task, Date week, Date fromDay, Date toDay) {
        long result = 0L;
        Calendar beginPeriodDate = Calendar.getInstance();
        beginPeriodDate.setTime(week);
        beginPeriodDate.set(7, beginPeriodDate.getFirstDayOfWeek());
        Calendar endPeriodDate = (Calendar)beginPeriodDate.clone();
        endPeriodDate.add(3, 1);
        endPeriodDate.add(6, -1);
        Calendar loopPeriodDate = beginPeriodDate;
        while (loopPeriodDate.compareTo(endPeriodDate) <= 0) {
            if (!(fromDay != null && fromDay.compareTo(loopPeriodDate.getTime()) > 0 || toDay != null && toDay.compareTo(loopPeriodDate.getTime()) < 0)) {
                result += TimerTaskHelper.getTotalTime(task, loopPeriodDate.getTime());
            }
            loopPeriodDate.add(6, 1);
        }
        return result;
    }

    public long getMonthlyTotalTaskTime(TimerTask task, Date month, Date fromDay, Date toDay) {
        long result = 0L;
        Calendar beginPeriodDate = Calendar.getInstance();
        beginPeriodDate.setTime(month);
        beginPeriodDate.set(5, 1);
        Calendar endPeriodDate = (Calendar)beginPeriodDate.clone();
        endPeriodDate.add(2, 1);
        endPeriodDate.add(6, -1);
        Calendar loopPeriodDate = beginPeriodDate;
        while (loopPeriodDate.compareTo(endPeriodDate) <= 0) {
            if (!(fromDay != null && fromDay.compareTo(loopPeriodDate.getTime()) > 0 || toDay != null && toDay.compareTo(loopPeriodDate.getTime()) < 0)) {
                result += TimerTaskHelper.getTotalTime(task, loopPeriodDate.getTime());
            }
            loopPeriodDate.add(6, 1);
        }
        return result;
    }

    public long getYearlyTotalTaskTime(TimerTask task, Date year, Date fromDay, Date toDay) {
        long result = 0L;
        Calendar beginPeriodDate = Calendar.getInstance();
        beginPeriodDate.setTime(year);
        beginPeriodDate.set(5, 1);
        beginPeriodDate.set(2, 0);
        Calendar endPeriodDate = (Calendar)beginPeriodDate.clone();
        endPeriodDate.add(1, 1);
        endPeriodDate.add(6, -1);
        Calendar loopPeriodDate = beginPeriodDate;
        while (loopPeriodDate.compareTo(endPeriodDate) <= 0) {
            if (!(fromDay != null && fromDay.compareTo(loopPeriodDate.getTime()) > 0 || toDay != null && toDay.compareTo(loopPeriodDate.getTime()) < 0)) {
                result += TimerTaskHelper.getTotalTime(task, loopPeriodDate.getTime());
            }
            loopPeriodDate.add(6, 1);
        }
        return result;
    }

    public String formatDuration(long duration) {
        String result = DurationFormatUtils.formatDuration((long)(duration * 1000L), (String)"HH:mm:ss");
        return result;
    }

    public List<String> getDailyTaskAnnotation(TimerTask task, Date day) {
        List<String> result = TimerTaskHelper.getAnnotation(task, day);
        return result;
    }

    public List<String> getWeeklyTaskAnnotation(TimerTask task, Date week, Date fromDay, Date toDay) {
        ArrayList<String> result = new ArrayList<String>();
        Calendar beginPeriodDate = Calendar.getInstance();
        beginPeriodDate.setTime(week);
        beginPeriodDate.set(7, beginPeriodDate.getFirstDayOfWeek());
        Calendar endPeriodDate = (Calendar)beginPeriodDate.clone();
        endPeriodDate.add(3, 1);
        endPeriodDate.add(6, -1);
        Calendar loopPeriodDate = beginPeriodDate;
        while (loopPeriodDate.compareTo(endPeriodDate) <= 0) {
            if (!(fromDay != null && fromDay.compareTo(loopPeriodDate.getTime()) > 0 || toDay != null && toDay.compareTo(loopPeriodDate.getTime()) < 0)) {
                List<String> anns = TimerTaskHelper.getAnnotation(task, loopPeriodDate.getTime());
                result.addAll(anns);
            }
            loopPeriodDate.add(6, 1);
        }
        return result;
    }

    public List<String> getMonthlyTaskAnnotation(TimerTask task, Date month, Date fromDay, Date toDay) {
        ArrayList<String> result = new ArrayList<String>();
        Calendar beginPeriodDate = Calendar.getInstance();
        beginPeriodDate.setTime(month);
        beginPeriodDate.set(5, 1);
        Calendar endPeriodDate = (Calendar)beginPeriodDate.clone();
        endPeriodDate.add(2, 1);
        endPeriodDate.add(6, -1);
        Calendar loopPeriodDate = beginPeriodDate;
        while (loopPeriodDate.compareTo(endPeriodDate) <= 0) {
            if (!(fromDay != null && fromDay.compareTo(loopPeriodDate.getTime()) > 0 || toDay != null && toDay.compareTo(loopPeriodDate.getTime()) < 0)) {
                List<String> anns = TimerTaskHelper.getAnnotation(task, loopPeriodDate.getTime());
                result.addAll(anns);
            }
            loopPeriodDate.add(6, 1);
        }
        return result;
    }

    public List<String> getYearlyTaskAnnotation(TimerTask task, Date year, Date fromDay, Date toDay) {
        ArrayList<String> result = new ArrayList<String>();
        Calendar beginPeriodDate = Calendar.getInstance();
        beginPeriodDate.setTime(year);
        beginPeriodDate.set(5, 1);
        beginPeriodDate.set(2, 0);
        Calendar endPeriodDate = (Calendar)beginPeriodDate.clone();
        endPeriodDate.add(1, 1);
        endPeriodDate.add(6, -1);
        Calendar loopPeriodDate = beginPeriodDate;
        while (loopPeriodDate.compareTo(endPeriodDate) <= 0) {
            if (!(fromDay != null && fromDay.compareTo(loopPeriodDate.getTime()) > 0 || toDay != null && toDay.compareTo(loopPeriodDate.getTime()) < 0)) {
                List<String> anns = TimerTaskHelper.getAnnotation(task, loopPeriodDate.getTime());
                result.addAll(anns);
            }
            loopPeriodDate.add(6, 1);
        }
        return result;
    }
}

