/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.alert;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.TimerAlert;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.ui.alert.AlertCellEditor;
import org.chorem.jtimer.ui.alert.AlertCellRenderer;
import org.chorem.jtimer.ui.alert.AlertTableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.View;

public class AlertEditor
extends FrameView
implements ListSelectionListener {
    private static final long serialVersionUID = 5606265095312928490L;
    protected TimerTask task;
    protected List<TimerAlert> alerts;
    protected TimerDataManager timerDataManager;
    protected JTable alertTable;
    protected AlertTableModel alertModel;
    protected boolean selectedAlert;

    public AlertEditor(Application application, TimerDataManager timerDataManager, TimerTask task) {
        super(application);
        this.task = task;
        this.timerDataManager = timerDataManager;
        this.alerts = new ArrayList<TimerAlert>();
        for (TimerAlert alert : task.getAlerts()) {
            this.alerts.add(alert.clone());
        }
        this.getFrame().setName("alertFrame");
        this.getFrame().setTitle(this.getResourceMap().getString("alert.title", new Object[0]));
        this.setComponent(this.getMainComponent());
    }

    protected JComponent getMainComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(this.getResourceMap().getString("alert.alertlist", new Object[0]));
        panel.add((Component)label, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        ArrayList<String> columnIdentifiers = new ArrayList<String>();
        columnIdentifiers.add(this.getResourceMap().getString("alert.type", new Object[0]));
        columnIdentifiers.add(this.getResourceMap().getString("alert.duration", new Object[0]));
        this.alertModel = new AlertTableModel(this.alerts, columnIdentifiers);
        this.alertTable = new JTable(this.alertModel);
        this.alertTable.setSelectionMode(0);
        this.alertTable.getColumnModel().getColumn(0).setCellEditor(new AlertCellEditor());
        this.alertTable.getColumnModel().getColumn(1).setCellEditor(new AlertCellEditor());
        this.alertTable.getColumnModel().getColumn(0).setCellRenderer(new AlertCellRenderer());
        this.alertTable.getColumnModel().getColumn(1).setCellRenderer(new AlertCellRenderer());
        this.alertTable.setRowHeight(30);
        this.alertTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane sp = new JScrollPane(this.alertTable);
        panel.add((Component)sp, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        JButton addButton = new JButton();
        addButton.setAction(this.getContext().getActionMap((Object)this).get((Object)"addAlert"));
        panel.add((Component)addButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JButton removeButton = new JButton();
        removeButton.setAction(this.getContext().getActionMap((Object)this).get((Object)"removeAlert"));
        panel.add((Component)removeButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JButton cancelButton = new JButton();
        cancelButton.setAction(this.getContext().getActionMap((Object)this).get((Object)"cancel"));
        panel.add((Component)cancelButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JButton saveButton = new JButton();
        saveButton.setAction(this.getContext().getActionMap((Object)this).get((Object)"save"));
        panel.add((Component)saveButton, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        return panel;
    }

    public boolean isSelectedAlert() {
        return this.selectedAlert;
    }

    public void setSelectedAlert(boolean selectedAlert) {
        boolean oldValue = this.selectedAlert;
        this.selectedAlert = selectedAlert;
        this.firePropertyChange("selectedAlert", oldValue, selectedAlert);
    }

    @Action
    public void addAlert() {
        TimerAlert alert = new TimerAlert();
        alert.setType(TimerAlert.Type.REACH_DAILY_TIME);
        this.alerts.add(alert);
        this.alertModel.fireTableDataChanged();
    }

    @Action(enabledProperty="selectedAlert")
    public void removeAlert() {
        int selectedRow = this.alertTable.getSelectedRow();
        TimerAlert alert = this.alerts.get(selectedRow);
        this.alerts.remove(alert);
        this.alertModel.fireTableDataChanged();
    }

    @Action
    public void save() {
        this.task.setAlert(this.alerts);
        this.timerDataManager.modifyAlert(this.task);
        this.getApplication().hide((View)this);
    }

    @Action
    public void cancel() {
        this.getApplication().hide((View)this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.setSelectedAlert(e.getFirstIndex() >= 0);
    }
}

