/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.data;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.DataEventListener;
import org.chorem.jtimer.data.VetoableDataEventListener;
import org.chorem.jtimer.entities.TimerAlert;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;

public class TimerDataManager {
    private static Log log = LogFactory.getLog(TimerDataManager.class);
    protected List<TimerProject> projectList = new ArrayList<TimerProject>();
    protected Collection<DataEventListener> dataEventListeners = new ArrayList<DataEventListener>();
    protected Collection<VetoableDataEventListener> vetoableDataEventListeners = new ArrayList<VetoableDataEventListener>();

    public synchronized void addDataEventListener(DataEventListener listener) {
        this.dataEventListeners.add(listener);
    }

    public synchronized void removeDataEventListener(DataEventListener listener) {
        this.dataEventListeners.remove(listener);
    }

    public synchronized void addVetoableDataEventListener(VetoableDataEventListener listener) {
        this.vetoableDataEventListeners.add(listener);
    }

    public synchronized void removeVetoableDataEventListener(VetoableDataEventListener listener) {
        this.vetoableDataEventListeners.remove(listener);
    }

    public synchronized void addProject(TimerProject project) {
        Iterator<VetoableDataEventListener> itVetoableDataEventListener = this.vetoableDataEventListeners.iterator();
        while (itVetoableDataEventListener.hasNext()) {
            itVetoableDataEventListener.next().checkAddProject(project);
        }
        this.projectList.add(project);
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().addProject(project);
        }
    }

    public synchronized void addTask(TimerTask parent, TimerTask task) {
        Iterator<VetoableDataEventListener> itVetoableDataEventListener = this.vetoableDataEventListeners.iterator();
        while (itVetoableDataEventListener.hasNext()) {
            itVetoableDataEventListener.next().checkAddTask(parent, task);
        }
        parent.addTask(task);
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().addTask(task);
        }
    }

    public synchronized void addAllProjects(Collection<TimerProject> projects) {
        if (projects != null) {
            this.projectList.clear();
            this.projectList.addAll(projects);
            Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
            while (itDataEventListener.hasNext()) {
                itDataEventListener.next().dataLoaded(projects);
            }
        }
    }

    public synchronized List<TimerProject> getProjectsList() {
        return this.projectList;
    }

    public synchronized void changeTaskTime(TimerTask task, Date date, long value) {
        Iterator<VetoableDataEventListener> itVetoableDataEventListener = this.vetoableDataEventListeners.iterator();
        while (itVetoableDataEventListener.hasNext()) {
            itVetoableDataEventListener.next().checkSetTaskTime(task, date, value);
        }
        task.setTime(date, value);
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().setTaskTime(task, date, value);
        }
    }

    public synchronized void startTask(TimerTask task) {
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().startTask(task);
        }
    }

    public synchronized void stopTask(TimerTask task) {
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().stopTask(task);
        }
    }

    public synchronized void deleteTask(TimerTask task) {
        Iterator<VetoableDataEventListener> itVetoableDataEventListener = this.vetoableDataEventListeners.iterator();
        while (itVetoableDataEventListener.hasNext()) {
            itVetoableDataEventListener.next().checkDeleteTask(task);
        }
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().preDeleteTask(task);
        }
        task.getParent().getSubTasks().remove(task);
        itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().deleteTask(task);
        }
    }

    public synchronized void deleteProject(TimerProject project) {
        Iterator<VetoableDataEventListener> itVetoableDataEventListener = this.vetoableDataEventListeners.iterator();
        while (itVetoableDataEventListener.hasNext()) {
            itVetoableDataEventListener.next().checkDeleteProject(project);
        }
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().preDeleteProject(project);
        }
        this.projectList.remove(project);
        itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().deleteProject(project);
        }
    }

    public synchronized void changeProjectCloseState(TimerProject project) {
        this.changeTaskCloseState(project);
    }

    public synchronized void changeTaskCloseState(TimerTask task) {
        Iterator<VetoableDataEventListener> itVetoableDataEventListener = this.vetoableDataEventListeners.iterator();
        while (itVetoableDataEventListener.hasNext()) {
            itVetoableDataEventListener.next().checkChangeClosedState(task);
        }
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().preChangeClosedState(task);
        }
        task.setClosed(!task.isClosed());
        itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().postChangeClosedState(task);
        }
    }

    public synchronized void editProject(TimerProject project, String newProjectName) {
        TimerProject newProject = project.clone();
        newProject.setName(newProjectName);
        Iterator<VetoableDataEventListener> itVetoableDataEventListener = this.vetoableDataEventListeners.iterator();
        while (itVetoableDataEventListener.hasNext()) {
            itVetoableDataEventListener.next().checkModifyProject(newProject);
        }
        project.setName(newProjectName);
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().modifyProject(project);
        }
    }

    public synchronized void editTask(TimerTask task, String newTaskName) {
        TimerTask newTask = task.clone();
        newTask.setName(newTaskName);
        Iterator<VetoableDataEventListener> itVetoableDataEventListener = this.vetoableDataEventListeners.iterator();
        while (itVetoableDataEventListener.hasNext()) {
            itVetoableDataEventListener.next().checkChangeClosedState(newTask);
        }
        task.setName(newTaskName);
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().modifyTask(task);
        }
    }

    public synchronized void moveTask(TimerTask destination, Collection<TimerTask> tasksToMove) {
        Iterator<VetoableDataEventListener> itVetoableDataEventListener = this.vetoableDataEventListeners.iterator();
        while (itVetoableDataEventListener.hasNext()) {
            itVetoableDataEventListener.next().checkMoveTask(destination, tasksToMove);
        }
        for (TimerTask taskToMove : tasksToMove) {
            Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
            while (itDataEventListener.hasNext()) {
                itDataEventListener.next().preMoveTask(taskToMove);
            }
            TimerTask actualParent = taskToMove.getParent();
            actualParent.getSubTasks().remove(taskToMove);
            destination.addTask(taskToMove);
            itDataEventListener = this.dataEventListeners.iterator();
            while (itDataEventListener.hasNext()) {
                itDataEventListener.next().moveTask(taskToMove);
            }
        }
    }

    public synchronized void mergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
        Iterator<VetoableDataEventListener> itVetoableDataEventListener = this.vetoableDataEventListeners.iterator();
        while (itVetoableDataEventListener.hasNext()) {
            itVetoableDataEventListener.next().checkMergeTasks(destinationTask, otherTasks);
        }
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().preMergeTasks(destinationTask, otherTasks);
        }
        for (TimerTask otherTask : otherTasks) {
            this.mergeTwoTasks(destinationTask, otherTask);
        }
        itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().postMergeTasks(destinationTask, otherTasks);
        }
    }

    protected void mergeTwoTasks(TimerTask destinationTask, TimerTask otherTask) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Merging two task : " + destinationTask.getName() + " and " + otherTask.getName()));
        }
        ArrayList<TimerTask> otherTaskSubTasks = new ArrayList<TimerTask>(otherTask.getSubTasks());
        for (TimerTask timerTask : otherTaskSubTasks) {
            TimerTask sameTaskNameTask = null;
            for (TimerTask destSubTask : destinationTask.getSubTasks()) {
                if (!destSubTask.getName().equals(timerTask.getName())) continue;
                sameTaskNameTask = destSubTask;
            }
            if (sameTaskNameTask == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Moving task " + timerTask.getName() + " to " + destinationTask.getName()));
                }
                this.moveTask(destinationTask, Collections.singleton(timerTask));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sub-merging of " + sameTaskNameTask.getName() + " and " + timerTask.getName()));
            }
            this.mergeTwoTasks(sameTaskNameTask, timerTask);
        }
        for (Map.Entry entry : otherTask.getAllDaysAndTimes().entrySet()) {
            Long currentDuration = destinationTask.getTime((Date)entry.getKey());
            currentDuration = currentDuration + (Long)entry.getValue();
            destinationTask.setTime((Date)entry.getKey(), currentDuration);
        }
        for (Map.Entry entry : otherTask.getAllDaysAnnotations().entrySet()) {
            Date noteKey = (Date)entry.getKey();
            while (destinationTask.getAllDaysAnnotations().containsKey(noteKey)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Annotation collision detected, try next second");
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(noteKey);
                calendar.add(13, 1);
                noteKey = calendar.getTime();
            }
            destinationTask.addAnnotation(noteKey, (String)entry.getValue());
        }
        for (TimerAlert timerAlert : otherTask.getAlerts()) {
            destinationTask.addAlert(timerAlert);
        }
        this.deleteTask(otherTask);
    }

    public synchronized void addAnnotation(TimerTask task, Date date, String annotation) {
        Iterator<VetoableDataEventListener> itVetoableDataEventListener = this.vetoableDataEventListeners.iterator();
        while (itVetoableDataEventListener.hasNext()) {
            itVetoableDataEventListener.next().checkSetAnnotation(task, date, annotation);
        }
        task.addAnnotation(date, annotation);
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().setAnnotation(task, date, annotation);
        }
    }

    public synchronized void modifyAlert(TimerTask task) {
        Iterator<DataEventListener> itDataEventListener = this.dataEventListeners.iterator();
        while (itDataEventListener.hasNext()) {
            itDataEventListener.next().modifyTask(task);
        }
    }
}

