/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimer;
import org.chorem.jtimer.io.Saver;
import org.chorem.jtimer.ws.ProjectManagement;

public class JTimerFactory {
    private static Log log = LogFactory.getLog(JTimerFactory.class);
    protected static final long DEFAULT_IDLE_TIME = 300000L;
    protected static Properties props;
    protected static long idleTime;
    protected static ProjectManagement projectManagement;
    protected static Saver saver;

    protected JTimerFactory() {
    }

    protected static void init() {
        block10: {
            if (props == null) {
                try {
                    File homeUserFile;
                    props = new Properties();
                    String fileName = JTimerFactory.getConfigurationFileName();
                    URL url = JTimerFactory.class.getResource("/" + fileName);
                    props.load(url.openStream());
                    File currentDirectoryFile = new File(fileName);
                    if (currentDirectoryFile.canRead()) {
                        props.load(new FileInputStream(currentDirectoryFile));
                    }
                    if ((homeUserFile = new File(JTimerFactory.getUserHomeConfigurationFilePath())).exists()) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Use user home configuration in " + homeUserFile.getAbsolutePath()));
                        }
                        props.load(new FileInputStream(homeUserFile));
                    } else {
                        if (homeUserFile.getParentFile() != null && !homeUserFile.getParentFile().exists()) {
                            homeUserFile.getParentFile().mkdirs();
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Creating directory " + homeUserFile.getParentFile().getAbsolutePath()));
                            }
                        }
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Creating new default configuration file in " + homeUserFile.getAbsolutePath()));
                        }
                        URL defautFileURL = JTimerFactory.class.getResource("/" + JTimerFactory.getDefaultConfigurationFileName());
                        JTimerFactory.copyConfigurationFile(defautFileURL, homeUserFile);
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block10;
                    log.error((Object)"Can't read configuration file", (Throwable)e);
                }
            }
        }
    }

    protected static String getUserHomeConfigurationFilePath() {
        String filePath = System.getProperty("user.home");
        filePath = filePath + File.separator + ".jtimer";
        filePath = filePath + File.separator + JTimerFactory.getConfigurationFileName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Look for configuration file in : " + filePath));
        }
        return filePath;
    }

    protected static String getConfigurationFileName() {
        String fileName = JTimer.class.getSimpleName() + ".properties";
        return fileName;
    }

    protected static String getDefaultConfigurationFileName() {
        String fileName = JTimer.class.getSimpleName() + "_default.properties";
        return fileName;
    }

    protected static void copyConfigurationFile(URL copyFrom, File copyTo) throws IOException {
        InputStream in = copyFrom.openStream();
        FileOutputStream out = new FileOutputStream(copyTo);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        ((OutputStream)out).close();
    }

    public static ProjectManagement getProjectManagementService() {
        block11: {
            if (projectManagement == null) {
                JTimerFactory.init();
                String implementationClass = props.getProperty("jtimer.service.class");
                String serviceEndPoint = props.getProperty("jtimer.service.endpoint");
                String serviceResouceName = props.getProperty("jtimer.service.resource");
                if (log.isInfoEnabled()) {
                    log.info((Object)("Using service class : " + implementationClass));
                    log.info((Object)(" with service endpoint : " + serviceEndPoint));
                    log.info((Object)(" with service resource : " + serviceResouceName));
                }
                if (implementationClass != null) {
                    try {
                        projectManagement = (ProjectManagement)Class.forName(implementationClass).newInstance();
                        projectManagement.setEndpoint(serviceEndPoint);
                        projectManagement.setResourceName(serviceResouceName);
                    }
                    catch (InstantiationException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Can't instanciate class : " + implementationClass), (Throwable)e);
                        }
                        break block11;
                    }
                    catch (IllegalAccessException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Can't access class : " + implementationClass), (Throwable)e);
                        }
                        break block11;
                    }
                    catch (ClassNotFoundException e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Can't found class : " + implementationClass), (Throwable)e);
                        }
                        break block11;
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"No sync information given, won't synchronize");
                }
            }
        }
        return projectManagement;
    }

    public static Saver getFileSaver() {
        block11: {
            if (saver == null) {
                JTimerFactory.init();
                String implementationClass = props.getProperty("jtimer.io.saver.class");
                String saverDirectory = props.getProperty("jtimer.io.saver.directory");
                String autoSaveDelay = props.getProperty("jtimer.io.saver.autosavedelay");
                saverDirectory = JTimerFactory.getHomeReplacement(saverDirectory);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Using saver class : " + implementationClass));
                    log.info((Object)(" with saver home directory : " + saverDirectory));
                    log.info((Object)(" with auto save delay : " + autoSaveDelay));
                }
                try {
                    saver = (Saver)Class.forName(implementationClass).newInstance();
                    saver.setSaveDirectory(saverDirectory);
                    try {
                        long autoSaveDelayInS = Long.parseLong(autoSaveDelay);
                        saver.setAutoSaveDelay(autoSaveDelayInS * 1000L);
                    }
                    catch (NumberFormatException e) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"jtimer.io.saver.autosavedelay is non numeric value", (Throwable)e);
                        }
                    }
                }
                catch (InstantiationException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Can't instanciate class : " + implementationClass), (Throwable)e);
                    }
                }
                catch (IllegalAccessException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Can't access class : " + implementationClass), (Throwable)e);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!log.isErrorEnabled()) break block11;
                    log.error((Object)("Can't found class : " + implementationClass), (Throwable)e);
                }
            }
        }
        return saver;
    }

    protected static String getHomeReplacement(String path) {
        String localPath = path;
        if (localPath != null) {
            localPath = localPath.replace("/", File.separator);
            String escapedUserHome = System.getProperty("user.home").replaceAll("\\\\", "\\\\\\\\");
            localPath = localPath.replaceFirst("\\$HOME", escapedUserHome);
        }
        return localPath;
    }

    public static long getIdleTime() {
        if (idleTime <= 0L) {
            JTimerFactory.init();
            String idleTimeInS = props.getProperty("jtimer.ui.idletime");
            if (idleTimeInS == null) {
                idleTime = 300000L;
            } else {
                try {
                    idleTime = Long.parseLong(idleTimeInS) * 1000L;
                }
                catch (NumberFormatException e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Can't get idle time as number, using default idle time", (Throwable)e);
                    }
                    idleTime = 300000L;
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Idle time set to : " + idleTime + "ms"));
            }
        }
        return idleTime;
    }

    static {
        idleTime = -1L;
    }
}

