/*
 * #%L
 * jTimer
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
/* *##%
 * Copyright (C) 2007,2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.DataEventListener;
import org.chorem.jtimer.data.TimerCore;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;

/**
 * Gere l'affichage des noeuds de l'arbre.
 * 
 * Comme une icone quand la taches est lancee...
 * 
 * @author chatellier
 * @version $Revision: 2698 $
 * 
 * Last update : $Date: 2009-11-16 10:39:06 +0100 (lun., 16 nov. 2009) $
 * By : $Author: echatellier $
 */
public class ProjectsAndTasksCellRenderer extends DefaultTreeCellRenderer
        implements DataEventListener {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1383276150996517529L;

    /** Logger. */
    private static Log log = LogFactory.getLog(ProjectsAndTasksCellRenderer.class);

    /** Running task icon. */
    protected ImageIcon runningIcon;

    /** Running tasks. */
    protected Collection<TimerTask> runningTasks;

    /**
     * Constructor.
     * 
     * @param core TimerCore
     */
    public ProjectsAndTasksCellRenderer(TimerCore core) {
        super();

        // init
        runningTasks = new HashSet<TimerTask>();

        URL runnigIconUrl = ProjectsAndTasksCellRenderer.class
                .getResource("/org/chorem/jtimer/resources/running.gif");
        runningIcon = new ImageIcon(runnigIconUrl);

        // be notified on events
        core.getData().addDataEventListener(this);
    }

    /*
     * @see org.jdesktop.swingx.renderer.DefaultTreeRenderer#getTreeCellRendererComponent(javax.swing.JTree, java.lang.Object, boolean, boolean, boolean, int, boolean)
     */
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value,
            boolean selected, boolean expanded, boolean leaf, int row,
            boolean hasFocus) {

        super.getTreeCellRendererComponent(tree, value,
                selected, expanded, leaf, row, hasFocus);

        // if this is a task
        if (value instanceof TimerTask) {
            TimerTask task = (TimerTask) value;

            // add style in project in sync
            String taskName = task.getName();
            if (task instanceof TimerProject
                    && ((TimerProject) task).isSynchronized()) {
                taskName = taskName
                        .substring(TimerProject.SYNCHRONIZED_PROJECT_NAME_PREFIX
                                .length());

                setFont(getFont().deriveFont(Font.ITALIC));
            } else {
                setFont(getFont().deriveFont(Font.PLAIN));
            }

            // task name should not be "null"
            setText(taskName);

            // add icon if task is running  
            if (runningTasks.contains(task)) {
                setIcon(runningIcon);
                runningIcon.setImageObserver(new NodeImageObserver(this));
            }
            else {
                // force no default icon
                setIcon(null);
            }

            // add color if task is closed
            if (task.isClosed()) {
                // fix selection color
                if (selected) {
                    setForeground(Color.GRAY.brighter());
                } else {
                    setForeground(Color.GRAY);
                }
            }
        }

        return this;
    }

    /**
     * Enclosed class to manage gif image refresh.
     */
    class NodeImageObserver implements ImageObserver {

        /** Label to add image. */
        protected JLabel jl;

        /**
         * Constructor.
         * 
         * @param jl label
         */
        public NodeImageObserver(JLabel jl) {
            this.jl = jl;
        }

        /*
         * @see java.awt.image.ImageObserver#imageUpdate(java.awt.Image, int, int, int, int, int)
         */
        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int w,
                int h) {
            if ((flags & (FRAMEBITS | ALLBITS)) != 0) {
                jl.repaint(x, y, w, h);
            }
            return (flags & (ALLBITS | ABORT)) == 0;
        }
    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#addProject(org.chorem.jtimer.entities.TimerProject)
     */
    @Override
    public void addProject(TimerProject project) {

    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#addTask(org.chorem.jtimer.entities.TimerTask)
     */
    @Override
    public void addTask(TimerTask task) {

    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#dataLoaded(java.util.Collection)
     */
    @Override
    public void dataLoaded(Collection<TimerProject> projects) {

    }

    /*
     * @see org.chorem.jtimer.data.DataEventListener#preDeleteProject(org.chorem.jtimer.entities.TimerProject)
     */
    @Override
    public void preDeleteProject(TimerProject project) {

    }

    /*
     * @see org.chorem.jtimer.data.DataEventListener#preDeleteTask(org.chorem.jtimer.entities.TimerTask)
     */
    @Override
    public void preDeleteTask(TimerTask task) {

    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#deleteProject(org.chorem.jtimer.entities.TimerProject)
     */
    @Override
    public void deleteProject(TimerProject project) {

    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#deleteTask(org.chorem.jtimer.entities.TimerTask)
     */
    @Override
    public void deleteTask(TimerTask task) {

    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#modifyProject(org.chorem.jtimer.entities.TimerProject)
     */
    @Override
    public void modifyProject(TimerProject project) {

    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#modifyTask(org.chorem.jtimer.entities.TimerTask)
     */
    @Override
    public void modifyTask(TimerTask task) {

    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#postChangeClosedState(org.chorem.jtimer.entities.TimerTask)
     */
    @Override
    public void postChangeClosedState(TimerTask task) {

    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#preChangeClosedState(org.chorem.jtimer.entities.TimerTask)
     */
    @Override
    public void preChangeClosedState(TimerTask task) {

    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#startTask(org.chorem.jtimer.entities.TimerTask)
     */
    @Override
    public void startTask(TimerTask task) {

        if (log.isDebugEnabled()) {
            log.debug("startTask on " + task.getName());
        }

        // remember running task
        runningTasks.add(task);
    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#stopTask(org.chorem.jtimer.entities.TimerTask)
     */
    @Override
    public void stopTask(TimerTask task) {

        if (log.isDebugEnabled()) {
            log.debug("stopTask on " + task.getName());
        }

        // remember don't running task
        runningTasks.remove(task);
    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#postMoveTask(org.chorem.jtimer.entities.TimerTask)
     */
    @Override
    public void moveTask(TimerTask task) {

    }

    /*
     * @see org.chorem.jtimer.data.event.DataEventListener#preMoveTask(org.chorem.jtimer.entities.TimerTask)
     */
    @Override
    public void preMoveTask(TimerTask task) {

    }

    /*
     * @see org.chorem.jtimer.data.DataEventListener#postMergeTasks(org.chorem.jtimer.entities.TimerTask, java.util.List)
     */
    @Override
    public void postMergeTasks(TimerTask destinationTask,
            List<TimerTask> otherTasks) {

    }

    /*
     * @see org.chorem.jtimer.data.DataEventListener#preMergeTasks(org.chorem.jtimer.entities.TimerTask, java.util.List)
     */
    @Override
    public void preMergeTasks(TimerTask destinationTask,
            List<TimerTask> otherTasks) {

    }

    /*
     * @see org.chorem.jtimer.event.DataEventListener#setTaskTime(org.chorem.jtimer.entities.TimerTask, java.util.Date, java.lang.Long)
     */
    @Override
    public void setTaskTime(TimerTask task, Date date, Long time) {

    }

    /*
     * @see org.chorem.jtimer.event.DataEventListener#setAnnotation(org.chorem.jtimer.entities.TimerTask, java.util.Date, java.lang.String)
     */
    @Override
    public void setAnnotation(TimerTask task, Date date, String annotation) {

    }
}
