/*
 * #%L
 * jTimer
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
/* *##%
 * Copyright (C) 2007,2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.system.win32;

import org.chorem.jtimer.ui.system.SystemInfo;

/**
 * Win32 System info.
 * 
 * From http://ochafik.free.fr/blog/?p=98
 * 
 * @author chatellier
 * @version $Revision: 2719 $
 * 
 * Last update : $Date: 2010-01-13 16:17:45 +0100 (mer., 13 janv. 2010) $
 * By : $Author: tchemit $
 */
public class Win32SystemInfo implements SystemInfo {

    /** {@link User32.LASTINPUTINFO}. */
    protected User32.LASTINPUTINFO lastInputInfo;

    /**
     * Constructor.
     * 
     * Package visibility
     */
    public Win32SystemInfo() {
        lastInputInfo = new User32.LASTINPUTINFO();
    }

    /**
     * Get the amount of milliseconds that have elapsed since the last input
     * event (mouse or keyboard)
     * 
     * @return idle time in milliseconds
     */
    public int getIdleTimeMillisWin32() {
        User32.INSTANCE.GetLastInputInfo(lastInputInfo);
        return Kernel32.INSTANCE.GetTickCount() - lastInputInfo.dwTime;
    }

    /*
     * @see org.chorem.jtimer.ui.system.SystemInfo#getIdleTime()
     */
    @Override
    public long getIdleTime() {
        long millisTime = getIdleTimeMillisWin32();
        return millisTime;
    }
}
