/*
 * #%L
 * jTimer
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
/* *##%
 * Copyright (C) 2008, 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.report;

import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import freemarker.cache.URLTemplateLoader;

/**
 * Freemarker custom template loader.
 * Load template from classpath jars.
 *
 * @author chatellier
 * @version $Revision: 2607 $
 * 
 * Last update : $Date: 2009-06-18 17:19:19 +0200 (jeu., 18 juin 2009) $
 * By : $Author: echatellier $
 */
public class ReportTemplateLoader extends URLTemplateLoader {

    /** log */
    private static Log log = LogFactory.getLog(ReportTemplateLoader.class);

    /** base dir for all template */
    protected String basedir = null;

    /**
     * Constructor.
     * 
     * @param basedir basedir
     */
    public ReportTemplateLoader(String basedir) {
        this.basedir = basedir;
    }

    /*
     * @see freemarker.cache.URLTemplateLoader#getURL(java.lang.String)
     */
    @Override
    protected URL getURL(String name) {

        if (log.isDebugEnabled()) {
            log.debug("Loading url template " + name);
        }

        URL url = ReportTemplateLoader.class.getResource(basedir + "/" + name);
        //URL url = ClassLoader.getSystemResource(basedir + "/" + name);

        return url;
    }

}
