/*
 * #%L
 * jTimer
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
/* *##%
 * Copyright (C) 2008, 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.data;

import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.List;

import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;

/**
 * Vetoable Data event listener.
 * 
 * @author chorlet
 * @version $Revision: 2687 $
 * 
 * Last update : $Date: 2009-11-03 11:06:13 +0100 (mar., 03 nov. 2009) $ By : $Author: echatellier $
 */
public interface VetoableDataEventListener extends EventListener {

    /**
     * Check add project.
     * 
     * @param project project to add
     */
    public void checkAddProject(TimerProject project);

    /**
     * Check add task.
     * 
     * @param parent parent task
     * @param task task to add
     */
    public void checkAddTask(TimerTask parent, TimerTask task);

    /**
     * Check modify project.
     * 
     * @param project modified project
     */
    public void checkModifyProject(TimerProject project);

    /**
     * Check modify task.
     * 
     * @param task modified task
     */
    public void checkModifyTask(TimerTask task);

    /**
     * Check delete project.
     * 
     * @param project deleted project
     */
    public void checkDeleteProject(TimerProject project);

    /**
     * Check delete task.
     * 
     * @param task deleted task
     */
    public void checkDeleteTask(TimerTask task);

    /**
     * Check update task annotation.
     * 
     * @param task task to update
     * @param date day of change 
     * @param value new annotation
     */
    public void checkSetAnnotation(TimerTask task, Date date, String value);

    /**
     * Check update task time.
     * 
     * @param task task to update
     * @param date day of change 
     * @param value new time in seconds
     */
    public void checkSetTaskTime(TimerTask task, Date date, Long value);

    /**
     * Check change task state.
     * 
     * @param task task
     */
    public void checkChangeClosedState(TimerTask task);

    /**
     * Check move task.
     * 
     * @param destination task to move to
     * @param tasksToMove tasks to move
     */
    public void checkMoveTask(TimerTask destination, Collection<TimerTask> tasksToMove);
    
    /**
     * Check merge task.
     * 
     * @param destinationTask task result of merge
     * @param otherTasks other task to merge
     */
    public void checkMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks);

}
