/*
 * #%L
 * jTimer
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
/* *##%
 * Copyright (C) 2007,2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimerFactory;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.io.DataLockingException;
import org.chorem.jtimer.io.Saver;
import org.chorem.jtimer.ws.ConnectionDataHandler;
import org.chorem.jtimer.ws.ProjectManagement;
import org.chorem.jtimer.ws.xmlrpc.WSDaemon;

/**
 * TimerCore
 * 
 * @author chatellier
 * @version $Revision: 2600 $
 * 
 * Last update : $Date: 2009-06-15 18:49:52 +0200 (lun., 15 juin 2009) $
 * By : $Author: echatellier $
 */
public class TimerCore {

    /** log. */
    private static Log log = LogFactory.getLog(TimerCore.class);

    /** Timer data. */
    protected TimerDataManager data;

    /** saver io controller. */
    protected Saver saver;

    /** Web service daemon. */
    protected WSDaemon webServiceDaemon;

    /** connection data handler */
    protected ConnectionDataHandler connectionHandler = null;

    /**
     * Constructor.
     */
    public TimerCore() {
        // init data
        data = new TimerDataManager();

        // add commmon vetoable
        CommonVetoable commonVetoable = new CommonVetoable(data);
        data.addVetoableDataEventListener(commonVetoable);

        // init saver implementation
        saver = JTimerFactory.getFileSaver();
        if (saver != null) {
            data.addVetoableDataEventListener(saver);
            data.addDataEventListener(saver);
        }

        // web service impl
        ProjectManagement managementService = JTimerFactory.getProjectManagementService();
        if (managementService != null) {
            managementService.setDataManager(data);
            data.addVetoableDataEventListener(managementService);
            data.addDataEventListener(managementService);
        }
    }

    /**
     * Init Load and launch synchronization.
     * 
     * @return true if init has gone successfully
     */
    public boolean init() {

        boolean initSucceded = false;

        // log
        if (log.isInfoEnabled()) {
            log.info("Init core");
        }

        try {
            saver.lock();

            load();

            initSucceded = true;
        } catch (DataLockingException e) {
            // can occurs if data save directory is locked
            if (log.isDebugEnabled()) {
                log.error("Data can't have been loaded");
            }
        }

        return initSucceded;
    }

    /**
     * Get data.
     * 
     * @return timer data
     */
    public TimerDataManager getData() {
        return data;
    }

    /**
     * Load project list from.
     */
    protected void load() {

        // log
        if (log.isInfoEnabled()) {
            log.info("Load local data");
        }

        Collection<TimerProject> projects = saver.load();

        // sort loaded collection
        List<TimerProject> projectsList = new ArrayList<TimerProject>(projects);
        Collections.sort(projectsList);

        data.addAllProjects(projectsList);
    }

    /**
     * Save.
     */
    public void exit() {
        if (log.isInfoEnabled()) {
            log.info("Exiting application");
        }

        // unlock fs directory
        try {
            saver.unlock();
        } catch (DataLockingException e) {
            if (log.isErrorEnabled()) {
                log.error("Error on unlocking", e);
            }
        }
    }
}
