/* *##%
 * Copyright (C) 2007,2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.system.win32;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;

/**
 * Win User32 JNA Interface.
 * 
 * @author chatellier
 * @version $Revision: 2719 $
 *
 * FIXME-TC2010011" : javadoc plugin says there is a missing closing tag ?
 * @see <a href="http://msdn.microsoft.com/library/default.asp?url=/library/en-us/winui/winui/windowsuserinterface/userinput/keyboardinput/keyboardinputreference/keyboardinputstructures/lastinputinfo.asp">Windows API</a>
 * 
 * Last update : $Date: 2010-01-13 16:17:45 +0100 (mer., 13 janv. 2010) $
 * By : $Author: tchemit $
 */
public interface User32 extends StdCallLibrary {

    /** Instance. */
    User32 INSTANCE = (User32) Native.loadLibrary("user32", User32.class);

    /**
     * Contains the time of the last input.
     */
    public static class LASTINPUTINFO extends Structure {
        public int cbSize = 8;

        // / Tick count of when the last input event was received.
        public int dwTime;
    }

    /**
     * Retrieves the time of the last input event.
     * 
     * @param result time of the last input event, in milliseconds
     * @return boolean flag
     */
    public boolean GetLastInputInfo(LASTINPUTINFO result);
}
