/* *##%
 * Copyright (C) 2007,2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ws.xmlrpc;

import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;

/**
 * AbstractXMLRPCClient
 * 
 * @author chatellier
 * @version $Revision: 2518 $
 * 
 * Last update : $Date: 2009-05-22 13:17:51 +0200 (ven., 22 mai 2009) $
 * By : $Author: chatellier $
 */
public abstract class AbstractXMLRPCClient {

    /** Log. */
    private static Log log = LogFactory.getLog(AbstractXMLRPCClient.class);

    /**
     * Get endpoint address.
     * 
     * @return endpoint address
     */
    protected abstract String getEndpoint();

    /**
     * Make get service call.
     * 
     * @param serviceName method to call
     * @param args method arguments
     * 
     * @return result remote method result
     * 
     * @throws XmlRpcException when there is an exception
     */
    protected Object get(String serviceName, Object... args)
            throws XmlRpcException {
        Object result = null;
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        try {
            config.setServerURL(new URL(getEndpoint()));
            XmlRpcClient client = new XmlRpcClient();
            client.setTransportFactory(new XmlRpcCommonsTransportFactory(
                            client));
            client.setConfig(config);
            result = client.execute(serviceName, args);
        } catch (java.net.MalformedURLException e) {
            if (log.isErrorEnabled()) {
                log.error("Malformed URL Exception", e);
            }
        }

        return result;
    }
}
