/* *##%
 * Copyright (C) 2007,2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.system.win32;

import org.chorem.jtimer.ui.system.SystemInfo;

import com.sun.jna.Native;

/**
 * Win32 System info.
 * 
 * From http://ochafik.free.fr/blog/?p=98
 * 
 * @author chatellier
 * @version $Revision: 2596 $
 * 
 * Last update : $Date: 2009-06-14 11:23:43 +0200 (dim., 14 juin 2009) $
 * By : $Author: echatellier $
 */
public class Win32SystemInfo implements SystemInfo {

    protected Kernel32 k32Instance;

    protected User32 u32Instance;

    protected User32.LASTINPUTINFO lastInputInfo;

    /**
     * Constructor.
     * 
     * Package visibility
     */
    public Win32SystemInfo() {
        k32Instance = (Kernel32) Native.loadLibrary("kernel32", Kernel32.class);
        u32Instance = (User32) Native.loadLibrary("user32", User32.class);
        lastInputInfo = new User32.LASTINPUTINFO();
    }

    /**
     * Get the amount of milliseconds that have elapsed since the last input
     * event (mouse or keyboard)
     * 
     * @return idle time in milliseconds
     */
    public int getIdleTimeMillisWin32() {
        u32Instance.GetLastInputInfo(lastInputInfo);
        return k32Instance.GetTickCount() - lastInputInfo.dwTime;
    }

    /*
     * @see org.chorem.jtimer.ui.system.SystemInfo#getIdleTime()
     */
    @Override
    public long getIdleTime() {
        long millisTime = getIdleTimeMillisWin32();
        return millisTime;
    }
}
