/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.report.tree;

import java.awt.Color;
import java.awt.Component;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;

public abstract class CheckBoxTreeCellComponent
extends JCheckBox {
    private static final long serialVersionUID = 2497464481840318274L;
    protected JTree parentTree;
    protected Set<TimerTask> uncheckedTaskSet;

    public CheckBoxTreeCellComponent(JTree parentTree, Set<TimerTask> uncheckedTaskList) {
        this.parentTree = parentTree;
        this.uncheckedTaskSet = uncheckedTaskList;
    }

    protected Component getCheckBoxComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        if (value instanceof TimerTask) {
            TimerTask task = (TimerTask)value;
            String taskName = task.getName();
            if (task instanceof TimerProject && ((TimerProject)task).isSynchronized()) {
                taskName = taskName.substring("#".length());
            }
            this.setText(taskName);
            if (task.isClosed()) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(Color.BLACK);
            }
            if (this.uncheckedTaskSet.contains(task)) {
                this.setSelected(false);
            } else {
                this.setSelected(true);
            }
        }
        return this;
    }
}

