/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.report;

import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.ui.report.ReportTemplateLoader;
import org.chorem.jtimer.ui.report.ReportUtils;

public class ReportGenerator {
    private static Log log = LogFactory.getLog(ReportGenerator.class);
    protected Configuration freemarkerConfiguration = new Configuration();

    public ReportGenerator() {
        this.freemarkerConfiguration.setEncoding(Locale.getDefault(), "UTF-8");
        ReportTemplateLoader templateLoader = new ReportTemplateLoader("/ftl");
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
        this.freemarkerConfiguration.setObjectWrapper((ObjectWrapper)new BeansWrapper());
    }

    public String getReportText(Type reportType, List<TimerProject> projects, Date begin, Date end, boolean includeAnnotate) {
        String content;
        block11: {
            Template template = null;
            content = null;
            try {
                switch (reportType) {
                    case BY_DAY_REPORT: {
                        template = this.freemarkerConfiguration.getTemplate("reportByDay.ftl");
                        break;
                    }
                    case BY_WEEK_REPORT: {
                        template = this.freemarkerConfiguration.getTemplate("reportByWeek.ftl");
                        break;
                    }
                    case BY_MONTH_REPORT: {
                        template = this.freemarkerConfiguration.getTemplate("reportByMonth.ftl");
                        break;
                    }
                    case BY_YEAR_REPORT: {
                        template = this.freemarkerConfiguration.getTemplate("reportByYear.ftl");
                        break;
                    }
                    case BY_PROJECT_REPORT: {
                        template = this.freemarkerConfiguration.getTemplate("reportByProject.ftl");
                    }
                }
                content = this.getReportContent(template, projects, begin, end, includeAnnotate);
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't get freemarker template", (Throwable)e);
                }
            }
            catch (TemplateException e) {
                if (!log.isErrorEnabled()) break block11;
                log.error((Object)"Can't get freemarker template", (Throwable)e);
            }
        }
        return content;
    }

    protected String getReportContent(Template template, List<TimerProject> projects, Date begin, Date end, boolean includeAnnotate) throws TemplateException, IOException {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("projects", projects);
        root.put("begin", begin);
        root.put("end", end);
        root.put("annotations", includeAnnotate);
        root.put("utils", new ReportUtils());
        StringWriter out = new StringWriter();
        template.process(root, (Writer)out);
        ((Writer)out).flush();
        return ((Object)out).toString();
    }

    public static enum Type {
        BY_DAY_REPORT,
        BY_WEEK_REPORT,
        BY_MONTH_REPORT,
        BY_YEAR_REPORT,
        BY_PROJECT_REPORT;

    }
}

