/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.alert;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.chorem.jtimer.entities.TimerAlert;

public class AlertTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 4103529427954019924L;
    protected List<String> columnIdentifiers;
    protected List<TimerAlert> alerts;

    public AlertTableModel(List<TimerAlert> alerts, List<String> columnIdentifiers) {
        this.alerts = alerts;
        this.columnIdentifiers = columnIdentifiers;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        String columnName = this.columnIdentifiers.get(column);
        return columnName;
    }

    @Override
    public int getRowCount() {
        return this.alerts.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TimerAlert alert = this.alerts.get(rowIndex);
        Object result = null;
        switch (columnIndex) {
            case 0: {
                result = alert.getType();
                break;
            }
            case 1: {
                result = alert.getDuration();
                break;
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        TimerAlert alert = this.alerts.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                TimerAlert.Type type = (TimerAlert.Type)((Object)value);
                alert.setType(type);
                break;
            }
            case 1: {
                long duration = (Long)value;
                alert.setDuration(duration);
                break;
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }
}

