/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.io;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GTimerTimeUtil {
    private static Log log = LogFactory.getLog(GTimerTimeUtil.class);
    protected static final DateFormat GTIMERDATEFORMAT = new SimpleDateFormat("yyyyMMdd");

    protected GTimerTimeUtil() {
    }

    public static Date yyyyMMdd2Date(String dateAsString) {
        Date date = null;
        try {
            String syear = dateAsString.substring(0, 4);
            String smonth = dateAsString.substring(4, 6);
            String sday = dateAsString.substring(6, 8);
            int year = Integer.parseInt(syear);
            int mouth = Integer.parseInt(smonth);
            int day = Integer.parseInt(sday);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, year);
            calendar.set(2, mouth - 1);
            calendar.set(5, day);
            date = calendar.getTime();
        }
        catch (NumberFormatException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Can't parse string " + dateAsString + " in yyyyMMdd format"), (Throwable)e);
            }
            throw new IllegalArgumentException("Can't parse string " + dateAsString + " in yyyyMMdd format", e);
        }
        return date;
    }

    public static String date2yyyyMMdd(Date date) {
        String dateAsString = GTIMERDATEFORMAT.format(date);
        return dateAsString;
    }
}

