/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimerFactory;
import org.chorem.jtimer.data.CommonVetoable;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.io.DataLockingException;
import org.chorem.jtimer.io.Saver;
import org.chorem.jtimer.ws.ConnectionDataHandler;
import org.chorem.jtimer.ws.ProjectManagement;
import org.chorem.jtimer.ws.xmlrpc.WSDaemon;

public class TimerCore {
    private static Log log = LogFactory.getLog(TimerCore.class);
    protected TimerDataManager data = new TimerDataManager();
    protected Saver saver;
    protected WSDaemon webServiceDaemon;
    protected ConnectionDataHandler connectionHandler = null;

    public TimerCore() {
        ProjectManagement managementService;
        CommonVetoable commonVetoable = new CommonVetoable(this.data);
        this.data.addVetoableDataEventListener(commonVetoable);
        this.saver = JTimerFactory.getFileSaver();
        if (this.saver != null) {
            this.data.addVetoableDataEventListener(this.saver);
            this.data.addDataEventListener(this.saver);
        }
        if ((managementService = JTimerFactory.getProjectManagementService()) != null) {
            managementService.setDataManager(this.data);
            this.data.addVetoableDataEventListener(managementService);
            this.data.addDataEventListener(managementService);
        }
    }

    public boolean init() {
        boolean initSucceded;
        block3: {
            initSucceded = false;
            if (log.isInfoEnabled()) {
                log.info((Object)"Init core");
            }
            try {
                this.saver.lock();
                this.load();
                initSucceded = true;
            }
            catch (DataLockingException e) {
                if (!log.isDebugEnabled()) break block3;
                log.error((Object)"Data can't have been loaded");
            }
        }
        return initSucceded;
    }

    public TimerDataManager getData() {
        return this.data;
    }

    protected void load() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Load local data");
        }
        Collection<TimerProject> projects = this.saver.load();
        ArrayList<TimerProject> projectsList = new ArrayList<TimerProject>(projects);
        Collections.sort(projectsList);
        this.data.addAllProjects(projectsList);
    }

    public void exit() {
        block3: {
            if (log.isInfoEnabled()) {
                log.info((Object)"Exiting application");
            }
            try {
                this.saver.unlock();
            }
            catch (DataLockingException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Error on unlocking", (Throwable)e);
            }
        }
    }
}

