/* *##%
 * Copyright (C) 2007,2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.system.win32;

import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;

/**
 * Win User32 JNA Interface.
 * 
 * @author chatellier
 * @version $Revision: 2596 $
 * 
 * @see "http://msdn.microsoft.com/library/default.asp?url=/library/en-us/winui/winui/windowsuserinterface/userinput/keyboardinput/keyboardinputreference/keyboardinputstructures/lastinputinfo.asp"
 * 
 * Last update : $Date: 2009-06-14 11:23:43 +0200 (dim. 14 juin 2009) $
 * By : $Author: echatellier $
 */
public interface User32 extends StdCallLibrary {

    /**
     * Contains the time of the last input.
     */
    public static class LASTINPUTINFO extends Structure {
        public int cbSize = 8;

        // / Tick count of when the last input event was received.
        public int dwTime;
    }

    /**
     * Retrieves the time of the last input event.
     * 
     * @param result time of the last input event, in milliseconds
     * @return boolean flag
     */
    public boolean GetLastInputInfo(LASTINPUTINFO result);
}
