/* *##%
 * Copyright (C) 2007,2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.system.unix;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;

/**
 * libXss JNA interface.
 * 
 * Incomplete definition.
 * 
 * @author chatellier
 * @version $Revision: 2518 $
 * 
 * Last update : $Date: 2009-05-22 13:17:51 +0200 (ven. 22 mai 2009) $
 * By : $Author: chatellier $
 */
public interface Xss extends Library {

    /** Xss Instance */
    Xss INSTANCE = (Xss) Native.loadLibrary("Xss", Xss.class);

    /**
     * XScreenSaverInfo struct
     */
    public static class XScreenSaverInfo extends Structure {
        public X11.Window window; /* screen saver window - may not exist */
        public int state; /* ScreenSaverOff, ScreenSaverOn, ScreenSaverDisabled */
        public int kind; /* ScreenSaverBlanked, ...Internal, ...External */
        public NativeLong til_or_since; /* time til or since screen saver */
        public NativeLong idle; /* total time since last user input */
        public NativeLong eventMask; /* currently selected events for this client */
    }

    /**
     * Information sur l'activation de l'ecran de veille de X11.
     * 
     * @param display display
     * @param event_base event_base
     * @param error_base error_base
     * 
     * @return true if XScreenSaver extension is loaded
     * 
     * @see com.sun.jna.ptr.IntByReference
     */
    public boolean XScreenSaverQueryExtension(X11.Display display,
            IntByReference event_base, IntByReference error_base);

    /**
     * XScreenSaverAllocInfo.
     * 
     * @return XScreenSaverInfo instance
     */
    public XScreenSaverInfo XScreenSaverAllocInfo();

    /**
     * XScreenSaverQueryInfo.
     * 
     * @param display
     * @param drawable
     * @param infos
     * @return status flag
     */
    public int XScreenSaverQueryInfo(X11.Display display,
            X11.Drawable drawable, XScreenSaverInfo infos);
}
