/* *##%
 * Copyright (C) 2007,2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.system;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.ui.system.unix.UnixSystemInfo;
import org.chorem.jtimer.ui.system.win32.Win32SystemInfo;

/**
 * Build system info determined from system.
 * 
 * @author chatellier
 * @version $Revision: 2518 $
 * 
 * Last update : $Date: 2009-05-22 13:17:51 +0200 (ven. 22 mai 2009) $
 * By : $Author: chatellier $
 */
public class SystemInfoFactory {

    /** log */
    private static Log log = LogFactory.getLog(SystemInfoFactory.class);

    /** Single instance */
    protected static SystemInfo instance;

    /**
     * SystemInfoFactory Constructor.
     */
    protected SystemInfoFactory() {

    }

    /**
     * Return system info depending on system.
     * 
     * @return SystemInfo instance
     * @see SystemInfo
     * @throws UnsupportedSystemInfoException if system info is not supported
     *             for system
     */
    public static SystemInfo getSystemInfo()
            throws UnsupportedSystemInfoException {

        if (instance == null) {
            String os = System.getProperty("os.name");

            // log it
            if (log.isInfoEnabled()) {
                log.info("Try do build system info for system : " + os);
            }

            // try windows
            if (os.contains("Windows")) {
                instance = new Win32SystemInfo();
            } else if (os.contains("Linux") || os.contains("Mac OS")) {
                instance = new UnixSystemInfo();
            } else {
                // system unknown
                throw new UnsupportedSystemInfoException(
                        "Can't get system info for " + os);
            }
        }

        return instance;
    }
}
