/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.alert;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import org.chorem.jtimer.entities.TimerAlert;
import org.chorem.jtimer.entities.TimerAlert.Type;

/**
 * Table model for alerts.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 6 juil. 2009 $
 * By : $Author: chatellier $
 */
public class AlertTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 4103529427954019924L;
    
    /** Table column identifiers. */
    protected List<String> columnIdentifiers;
    
    /** Edition alerts list. */
    protected List<TimerAlert> alerts;

    /**
     * Contructor.
     * 
     * @param alerts alerts list
     * @param columnIdentifiers columns identifiers
     */
    public AlertTableModel(List<TimerAlert> alerts, List<String> columnIdentifiers) {
        this.alerts = alerts;
        this.columnIdentifiers = columnIdentifiers;
    }

    /*
     * @see javax.swing.table.TableModel#getColumnCount()
     */
    @Override
    public int getColumnCount() {
        return 2;
    }

    /*
     * @see javax.swing.table.AbstractTableModel#getColumnName(int)
     */
    @Override
    public String getColumnName(int column) {
        
        String columnName = columnIdentifiers.get(column);
        return columnName;
    }

    /*
     * @see javax.swing.table.TableModel#getRowCount()
     */
    @Override
    public int getRowCount() {
        return alerts.size();
    }

    /*
     * @see javax.swing.table.TableModel#getValueAt(int, int)
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {

        TimerAlert alert = alerts.get(rowIndex);
        
        Object result = null;
        
        switch (columnIndex) {
        case 0:
            result = alert.getType();
            break;
            
        case 1:
            result = alert.getDuration();
            break;

        default:
            break;
        }
        
        return result;
    }

    /*
     * @see javax.swing.table.AbstractTableModel#setValueAt(java.lang.Object, int, int)
     */
    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        TimerAlert alert = alerts.get(rowIndex);

        switch (columnIndex) {
        case 0:
            Type type = (Type)value;
            alert.setType(type);
            break;
            
        case 1:
            long duration = ((Long)value).longValue();
            alert.setDuration(duration);
            break;

        default:
            break;
        }
    }

    /*
     * @see javax.swing.table.AbstractTableModel#isCellEditable(int, int)
     */
    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }
}
