Rapport par mois
================

<#macro displaySubtaskReport task periodTime identation=0>
  <#local ident=identation + 1/>
  <#list task.subTasks as subtask>
    <#local taskTotalTime=utils.getMonthlyTotalTaskTime(subtask, periodTime?date, begin?date, end?date)/>
    <#if taskTotalTime &gt; 0>
    	<#local taskTime=utils.getMonthlyTaskTime(subtask, periodTime?date, begin?date, end?date)/>
<#list 1..ident as i>  </#list>- ${subtask.name}<#if taskTime &gt; 0> : ${utils.formatDuration(taskTime)}</#if>
    	<#if annotations>
	    	<#local taskAnnotations=utils.getMonthlyTaskAnnotation(subtask, periodTime?date, begin?date, end?date)/>
	    	<#list taskAnnotations as taskAnnotation>
<#list 1..ident as i>  </#list>  * ${taskAnnotation}
      		</#list>
      	</#if>
  	  <@displaySubtaskReport task=subtask periodTime=periodTime identation=ident/>
  	</#if>
  </#list>
</#macro>

<#assign periods=utils.getMonthlyDates(begin?date,end?date)/>
<#list periods as period>
<#assign periodTotalTime=0/>
<#list projects as project>
  <#assign projectPeriodTotalTime=utils.getMonthlyTotalTaskTime(project, period?date, begin?date, end?date)/>
  <#assign periodTotalTime=periodTotalTime+projectPeriodTotalTime/>
</#list>
<#if periodTotalTime &gt; 0>

<#assign title="Mois ${period?date?string('MMMM yyyy')}"/>
${title}
${""?left_pad(title?length,"-")}

<#list projects as project>
<#assign periodProjectTotalTime=utils.getMonthlyTotalTaskTime(project, period?date, begin?date, end?date)/>
<#if periodProjectTotalTime &gt; 0>
- ${project.name}
<@displaySubtaskReport task=project periodTime=period/>
</#if>
</#list>

Total : ${utils.formatDuration(periodTotalTime)}
</#if>
</#list>
