/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.DataEventListener;
import org.chorem.jtimer.data.TimerCore;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;

public class ProjectsAndTasksCellRenderer
extends DefaultTreeCellRenderer
implements DataEventListener {
    private static final long serialVersionUID = 1383276150996517529L;
    private static Log log = LogFactory.getLog(ProjectsAndTasksCellRenderer.class);
    protected ImageIcon runningIcon;
    protected Collection<TimerTask> runningTasks = new HashSet<TimerTask>();

    public ProjectsAndTasksCellRenderer(TimerCore core) {
        URL runnigIconUrl = ProjectsAndTasksCellRenderer.class.getResource("/org/chorem/jtimer/resources/running.gif");
        this.runningIcon = new ImageIcon(runnigIconUrl);
        core.getData().addDataEventListener(this);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof TimerTask) {
            TimerTask task = (TimerTask)value;
            String taskName = task.getName();
            if (task instanceof TimerProject && ((TimerProject)task).isSynchronized()) {
                taskName = taskName.substring("#".length());
                this.setFont(this.getFont().deriveFont(2));
            } else {
                this.setFont(this.getFont().deriveFont(0));
            }
            this.setText(taskName);
            if (this.runningTasks.contains(task)) {
                this.setIcon(this.runningIcon);
                this.runningIcon.setImageObserver(new NodeImageObserver(this));
            } else {
                this.setIcon(null);
            }
            if (task.isClosed()) {
                if (selected) {
                    this.setForeground(Color.GRAY.brighter());
                } else {
                    this.setForeground(Color.GRAY);
                }
            }
        }
        return this;
    }

    @Override
    public void addProject(TimerProject project) {
    }

    @Override
    public void addTask(TimerTask task) {
    }

    @Override
    public void dataLoaded(Collection<TimerProject> projects) {
    }

    @Override
    public void deleteProject(TimerProject project) {
    }

    @Override
    public void deleteTask(TimerTask task) {
    }

    @Override
    public void modifyProject(TimerProject project) {
    }

    @Override
    public void modifyTask(TimerTask task) {
    }

    @Override
    public void postChangeClosedState(TimerTask task) {
    }

    @Override
    public void preChangeClosedState(TimerTask task) {
    }

    @Override
    public void startTask(TimerTask task) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("propertyChange (start) on " + task.getName()));
        }
        this.runningTasks.add(task);
    }

    @Override
    public void stopTask(TimerTask task) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("propertyChange (stop) on " + task.getName()));
        }
        this.runningTasks.remove(task);
    }

    @Override
    public void postMoveTask(TimerTask task) {
    }

    @Override
    public void preMoveTask(TimerTask task) {
    }

    @Override
    public void postMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }

    @Override
    public void preMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }

    @Override
    public void setTaskTime(TimerTask task, Date date, Long time) {
    }

    @Override
    public void setAnnotation(TimerTask task, Date date, String annotation) {
    }

    class NodeImageObserver
    implements ImageObserver {
        protected JLabel jl;

        public NodeImageObserver(JLabel jl) {
            this.jl = jl;
        }

        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
            if ((flags & 0x30) != 0) {
                this.jl.repaint(x, y, w, h);
            }
            return (flags & 0xA0) == 0;
        }
    }
}

