/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.tasks;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimer;
import org.chorem.jtimer.JTimerFactory;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.ui.system.SystemInfo;
import org.chorem.jtimer.ui.system.SystemInfoFactory;
import org.chorem.jtimer.ui.system.UnsupportedSystemInfoException;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;

public class RunTaskJob
extends Task<Void, Long> {
    private static Log log = LogFactory.getLog(RunTaskJob.class);
    protected JTimer parentApp;
    protected TimerTask managedTask;
    protected TimerDataManager dataManager;
    protected SystemInfo systemInfo;
    protected long taskTimingBeforeStartInMs;
    protected Calendar taskStartCalendar;
    protected long offsetTimeInMs;
    protected long lastPublishTimestamp;
    protected Boolean bWantToStop;
    public static final int REVERT = 0;
    public static final int CONTINUE = 1;
    public static final int RESUME = 2;

    public RunTaskJob(JTimer parentApp, TimerTask managedTask, TimerDataManager dataManager) {
        super((Application)parentApp);
        this.parentApp = parentApp;
        this.bWantToStop = Boolean.FALSE;
        this.managedTask = managedTask;
        this.dataManager = dataManager;
        try {
            this.systemInfo = SystemInfoFactory.getSystemInfo();
        }
        catch (UnsupportedSystemInfoException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get system info", (Throwable)e);
            }
            this.systemInfo = null;
        }
    }

    public TimerTask getTask() {
        return this.managedTask;
    }

    public void incrementTaskTime(long increment) {
        long nowTimestamp = Calendar.getInstance().getTimeInMillis();
        long localIncrement = increment;
        if (this.taskTimingBeforeStartInMs + nowTimestamp - this.taskStartCalendar.getTimeInMillis() + this.offsetTimeInMs + increment < 0L) {
            localIncrement = -(this.taskTimingBeforeStartInMs + nowTimestamp - this.taskStartCalendar.getTimeInMillis() + this.offsetTimeInMs);
        }
        this.offsetTimeInMs += localIncrement;
    }

    public void resetTiming() {
        this.taskStartCalendar = Calendar.getInstance();
        this.lastPublishTimestamp = this.taskStartCalendar.getTimeInMillis();
        this.taskTimingBeforeStartInMs = 0L;
        this.offsetTimeInMs = 0L;
    }

    protected void checkReset() {
        Calendar nowCalendar = Calendar.getInstance();
        if (nowCalendar.get(6) != this.taskStartCalendar.get(6)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Day change detected, reset timing");
            }
            this.resetTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground() throws Exception {
        this.parentApp.startedTask(this.managedTask);
        this.resetTiming();
        this.taskTimingBeforeStartInMs = this.managedTask.getTime(new Date()) * 1000L;
        long configIdleTime = JTimerFactory.getIdleTime();
        boolean dontWantToStop = true;
        while (dontWantToStop) {
            long loopTimestamp = Calendar.getInstance().getTimeInMillis();
            if (loopTimestamp - this.lastPublishTimestamp >= configIdleTime) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Hibernate detected, reseting timing");
                }
                this.resetTiming();
            }
            this.lastPublishTimestamp = loopTimestamp;
            long idleTime = 0L;
            if (this.systemInfo != null) {
                idleTime = this.systemInfo.getIdleTime();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User is idle since " + idleTime / 1000L + " s"));
                }
            }
            this.checkReset();
            if (idleTime >= JTimerFactory.getIdleTime()) {
                long currentTime;
                this.offsetTimeInMs -= configIdleTime;
                this.publish(new Long[]{this.taskTimingBeforeStartInMs + loopTimestamp - this.taskStartCalendar.getTimeInMillis() + this.offsetTimeInMs});
                JTimer parentApplication = (JTimer)this.getApplication();
                parentApplication.preIdleDetect();
                int option = ((JTimer)this.getApplication()).askIdleOption();
                parentApplication.postIdleDetect();
                this.lastPublishTimestamp = currentTime = Calendar.getInstance().getTimeInMillis();
                switch (option) {
                    case 0: {
                        ((JTimer)this.getApplication()).stopTask(this.managedTask);
                        break;
                    }
                    case 1: {
                        this.offsetTimeInMs += configIdleTime;
                        this.publish(new Long[]{this.taskTimingBeforeStartInMs + currentTime - this.taskStartCalendar.getTimeInMillis() + this.offsetTimeInMs});
                        break;
                    }
                    default: {
                        this.offsetTimeInMs -= currentTime - loopTimestamp;
                        this.publish(new Long[]{this.taskTimingBeforeStartInMs + currentTime - this.taskStartCalendar.getTimeInMillis() + this.offsetTimeInMs});
                        break;
                    }
                }
            } else {
                this.publish(new Long[]{this.taskTimingBeforeStartInMs + loopTimestamp - this.taskStartCalendar.getTimeInMillis() + this.offsetTimeInMs});
            }
            Thread.sleep(1000L);
            Boolean bl = this.bWantToStop;
            synchronized (bl) {
                dontWantToStop = this.bWantToStop == false;
            }
        }
        return null;
    }

    protected void process(List<Long> durations) {
        long currentDuration = durations.get(durations.size() - 1);
        this.dataManager.changeTaskTime(this.managedTask, new Date(), currentDuration / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantToStop() {
        Boolean bl = this.bWantToStop;
        synchronized (bl) {
            this.bWantToStop = Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopping() {
        boolean stopping = false;
        Boolean bl = this.bWantToStop;
        synchronized (bl) {
            stopping = this.bWantToStop;
        }
        return stopping;
    }
}

