/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.tasks;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.TimerCore;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;

public class RefreshTreeTask
extends java.util.TimerTask {
    private static Log log = LogFactory.getLog(RefreshTreeTask.class);
    protected TimerDataManager dataManager;

    public RefreshTreeTask(TimerCore core) {
        this.dataManager = core.getData();
    }

    @Override
    public void run() {
        log.info((Object)"Refresh tree");
        List<TimerProject> projects = this.dataManager.getProjectsList();
        this.refreshTasks(projects);
    }

    protected void refreshTasks(List<? extends TimerTask> tasks) {
        for (TimerTask timerTask : tasks) {
            this.refreshTasks(timerTask.getSubTasks());
            Date now = new Date();
            this.dataManager.changeTaskTime(timerTask, now, timerTask.getTime(now));
        }
    }
}

