/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.systray;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimer;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.ui.systray.SystrayManager;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;

public class AWTSystray
extends SystrayManager
implements ActionListener,
MouseListener,
PropertyChangeListener {
    private static Log log = LogFactory.getLog(AWTSystray.class);
    protected ResourceMap resourceMap;
    protected TrayIcon trayIcon;
    protected Image idleImage;
    protected Image runningImage;
    protected Image idleDetectImage;
    protected int nbTasksRunning = 0;
    protected JPopupMenu popup;
    protected JMenuItem showItem;

    protected AWTSystray(JTimer parent) {
        super(parent);
        ApplicationContext ctxt = parent.getContext();
        ResourceManager mgr = ctxt.getResourceManager();
        this.resourceMap = mgr.getResourceMap(AWTSystray.class);
        this.idleImage = this.resourceMap.getImageIcon("idleImage").getImage();
        this.runningImage = this.resourceMap.getImageIcon("runningImage").getImage();
        this.idleDetectImage = this.resourceMap.getImageIcon("idleDetectImage").getImage();
    }

    @Override
    public void install() {
        block2: {
            SystemTray tray = SystemTray.getSystemTray();
            this.popup = new JPopupMenu();
            this.showItem = new JMenuItem(this.resourceMap.getString("hideMenuText", new Object[0]));
            this.showItem.addActionListener(this);
            this.showItem.setActionCommand("showHide");
            this.popup.add(this.showItem);
            this.popup.addSeparator();
            JMenuItem quitItem = new JMenuItem(this.resourceMap.getString("quitMenuText", new Object[0]));
            quitItem.addActionListener(this);
            quitItem.setActionCommand("quit");
            this.popup.add(quitItem);
            this.trayIcon = new TrayIcon(this.idleImage, this.resourceMap.getString("tooltipIdleText", new Object[0]), null);
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addMouseListener(this);
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                tray.addPropertyChangeListener("trayIcons", this);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Error while setting system tray", (Throwable)e);
            }
        }
        super.install();
    }

    @Override
    public void startTask(TimerTask task) {
        this.startStopTask(task, true);
    }

    @Override
    public void stopTask(TimerTask task) {
        this.startStopTask(task, false);
    }

    protected void startStopTask(TimerTask task, boolean start) {
        this.nbTasksRunning = start ? ++this.nbTasksRunning : --this.nbTasksRunning;
        String message = null;
        if (this.nbTasksRunning == 0) {
            message = this.resourceMap.getString("tooltipIdleText", new Object[0]);
            this.trayIcon.setImage(this.idleImage);
        } else {
            this.trayIcon.setImage(this.runningImage);
            message = this.nbTasksRunning == 1 ? this.resourceMap.getString("tooltipRunningTaskText", new Object[]{this.nbTasksRunning}) : this.resourceMap.getString("tooltipRunningTasksText", new Object[]{this.nbTasksRunning});
        }
        this.trayIcon.setToolTip(message);
    }

    @Override
    public void postIdleDetect() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Post idle detect");
        }
        if (this.nbTasksRunning == 0) {
            this.trayIcon.setImage(this.idleImage);
        } else {
            this.trayIcon.setImage(this.runningImage);
        }
    }

    @Override
    public void preIdleDetect() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pre idle detect");
        }
        this.trayIcon.setImage(this.idleDetectImage);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block6: {
            String event = evt.getPropertyName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Property change on system tray : " + event));
            }
            if (event.equals("trayIcons")) {
                SystemTray tray;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Systray event : " + evt.getPropertyName()));
                }
                if ((tray = SystemTray.getSystemTray()) != null) {
                    try {
                        tray.add(this.trayIcon);
                    }
                    catch (AWTException e) {
                        if (!log.isErrorEnabled()) break block6;
                        log.error((Object)"System tray seems to become available, but can't set it !", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("showHide".equals(actionCommand)) {
            if (this.parent.getMainFrame().isVisible()) {
                this.parent.hide();
                this.showItem.setText(this.resourceMap.getString("showMenuText", new Object[0]));
            } else {
                this.parent.show();
                this.showItem.setText(this.resourceMap.getString("hideMenuText", new Object[0]));
            }
        }
        if ("quit".equals(actionCommand)) {
            this.parent.quit(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1 && e.getButton() == 1) {
            if (this.parent.getMainFrame().isVisible()) {
                this.showItem.setText(this.resourceMap.getString("showMenuText", new Object[0]));
                this.parent.hide();
            } else {
                this.showItem.setText(this.resourceMap.getString("hideMenuText", new Object[0]));
                this.parent.show();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getClickCount() == 1 && e.getButton() == 3) {
            this.popup.setLocation(e.getX(), e.getY());
            this.popup.setInvoker(this.popup);
            this.popup.setVisible(true);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.parent.hide();
        this.showItem.setText(this.resourceMap.getString("showMenuText", new Object[0]));
    }
}

