/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.system;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.ui.system.SystemInfo;
import org.chorem.jtimer.ui.system.UnsupportedSystemInfoException;
import org.chorem.jtimer.ui.system.unix.UnixSystemInfo;
import org.chorem.jtimer.ui.system.win32.Win32SystemInfo;

public class SystemInfoFactory {
    private static Log log = LogFactory.getLog(SystemInfoFactory.class);
    protected static SystemInfo instance;

    protected SystemInfoFactory() {
    }

    public static SystemInfo getSystemInfo() throws UnsupportedSystemInfoException {
        if (instance == null) {
            String os = System.getProperty("os.name");
            if (log.isInfoEnabled()) {
                log.info((Object)("Try do build system info for system : " + os));
            }
            if (os.contains("Windows")) {
                instance = new Win32SystemInfo();
            } else if (os.contains("Linux") || os.contains("Mac OS")) {
                instance = new UnixSystemInfo();
            } else {
                throw new UnsupportedSystemInfoException("Can't get system info for " + os);
            }
        }
        return instance;
    }
}

