/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.report.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.TimerCore;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.entities.TimerTaskHelper;
import org.jdesktop.swingx.tree.TreeModelSupport;

public class CheckBoxTreeModel
implements TreeModel {
    private static final long serialVersionUID = -4312274996927222628L;
    private static Log log = LogFactory.getLog(CheckBoxTreeModel.class);
    protected TreeModelSupport modelSupport;
    protected TimerCore core;
    protected TimerTask root;
    protected boolean showClosed;

    public CheckBoxTreeModel(TimerCore core) {
        this.core = core;
        this.root = new TimerTask("Root");
        this.modelSupport = new TreeModelSupport((TreeModel)this);
    }

    @Override
    public Object getChild(Object parent, int index) {
        TimerTask child = this.getChildrenFor(parent).get(index);
        return child;
    }

    @Override
    public int getChildCount(Object parent) {
        int count = this.getChildrenFor(parent).size();
        return count;
    }

    protected List<TimerTask> getChildrenFor(Object parent) {
        List<TimerTask> result = this.getFiteredSubListFor(parent);
        return result;
    }

    protected List<TimerTask> getFiteredSubListFor(Object parent) {
        ArrayList<TimerTask> result = new ArrayList<TimerTask>();
        if (parent == this.root) {
            result.addAll(this.core.getData().getProjectsList());
        } else {
            TimerTask task = (TimerTask)parent;
            result.addAll(TimerTaskHelper.getSubTasksOrderedByName(task));
        }
        if (!this.showClosed) {
            CollectionUtils.filter(result, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    boolean result = false;
                    if (object instanceof TimerTask) {
                        TimerTask task = (TimerTask)object;
                        result = !task.isClosed();
                    }
                    return result;
                }
            });
        }
        return result;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int count = this.getChildrenFor(parent).indexOf(parent);
        return count;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.modelSupport.addTreeModelListener(l);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.modelSupport.removeTreeModelListener(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void setShowClosed(boolean closed) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Property changed showClosed : " + closed));
        }
        this.showClosed = closed;
        this.modelSupport.fireNewRoot();
    }
}

